#' Simulated income data
#'
#' Fictitious cross-sectional dataset used to illustrate the Lorenz regression methodology. It covers 7 variables for 200 individuals aged between 25 and 30 years.
#'
#' @format A data frame with 200 rows and 7 columns:
#' \describe{
#'     \item{Income}{Individual's labor income}
#'     \item{Sex}{Sex (0=Female, 1=Male)}
#'     \item{Health.level}{Variable ranging from 0 to 10 indicating the individual health's level (0 is worst, 10 is best)}
#'     \item{Age}{Individual's age in years, ranging from 25 to 30}
#'     \item{Work.Hours}{Individual's weekly work hours}
#'     \item{Education}{Individual's highest grade completed in years}
#'     \item{Seniority}{Length of service in years with the individual's employer}
#' }
#'
#' @usage data(Data.Incomes)
#'
#'
"Data.Incomes"
