% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-BIC.R
\name{PLR.BIC}
\alias{PLR.BIC}
\title{Determines the regularization parameter (lambda) in a PLR via optimization of an information criterion.}
\usage{
PLR.BIC(YX_mat, theta, weights = NULL, IC = c("BIC", "AIC"))
}
\arguments{
\item{YX_mat}{A matrix with the first column corresponding to the response vector, the remaining ones being the explanatory variables.}

\item{theta}{matrix gathering the path of estimated parameter vectors. Each row corresponds to a given covariate. Each column corresponds to a given value of lambda}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{IC}{indicates which information criterion is used. Possibles values are "BIC" (default) or "AIC".}
}
\value{
A list with two components
\describe{
   \item{\code{val}}{vector indicating the value attained by the information criterion for each value of lambda.}
   \item{\code{best}}{index of the value of lambda where the optimum is attained.}
}
}
\description{
\code{PLR.BIC} takes as input a matrix of estimated parameter vectors, where each row corresponds to a covariate and each column corresponds to a value of lambda,
and returns the index of the optimal column by optimizing an information criterion. By default the BIC is used.
}
\section{References}{

Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2022). A penalised bootstrap estimation procedure for the explained Gini coefficient.
}

\examples{
data(Data.Incomes)
YX_mat <- Data.Incomes[,-2]
PLR <- PLR.wrap(YX_mat, h = nrow(YX_mat)^(-1/5.5), eps = 0.005)
PLR.BIC(YX_mat, PLR$theta)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{PLR.wrap}}, \code{\link{Lorenz.FABS}}, \code{\link{Lorenz.SCADFABS}}
}
