% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gini-coefficient.R
\name{Gini.coef}
\alias{Gini.coef}
\title{Concentration index of \emph{y} with respect to \emph{x}}
\usage{
Gini.coef(
  y,
  x = y,
  na.rm = TRUE,
  ties.method = c("mean", "random"),
  seed = NULL,
  weights = NULL
)
}
\arguments{
\item{y}{variable of interest.}

\item{x}{variable to use for the ranking. By default \eqn{x=y}, and the obtained concentration index is the Gini coefficient of \emph{y}.}

\item{na.rm}{should missing values be deleted. Default value is \code{TRUE}. If \code{FALSE} is selected, missing values generate an error message}

\item{ties.method}{What method should be used to break the ties in the rank index. Possible values are "mean" (default value) or "random". If "random" is selected, the ties are broken by further ranking in terms of a uniformly distributed random variable. If "mean" is selected, the average rank method is used.}

\item{seed}{fixes what seed is imposed for the generation of the vector of uniform random variables used to break the ties. Default is NULL, in which case no seed is imposed.}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}
}
\value{
The value of the concentration index (or Gini coefficient)
}
\description{
\code{Gini.coef} computes the concentration index of a vector \emph{y} with respect to another vector \emph{x}.
If \emph{y} and \emph{x} are identical, the obtained concentration index boils down to the Gini coefficient.
}
\details{
The parameter \code{seed} allows for local seed setting to control randomness in the generation of the uniform random variables.
The specified seed is applied to the respective part of the computation, and the seed is reverted to its previous state after the operation.
This ensures that the seed settings do not interfere with the global random state or other parts of the code.
}
\examples{
data(Data.Incomes)
# We first compute the Gini coefficient of Income
Y <- Data.Incomes$Income
Gini.coef(y = Y)
# Then we compute the concentration index of Income with respect to Age
X <- Data.Incomes$Age
Gini.coef(y = Y, x = X)

}
\seealso{
\code{\link{Lorenz.curve}}, \code{\link{Lorenz.graphs}}
}
