% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR-confint.R
\name{confint.LR_boot}
\alias{confint.LR_boot}
\alias{confint.LR}
\title{Confidence intervals for the Lorenz regression}
\usage{
\method{confint}{LR_boot}(
  object,
  parm = c("Gini", "LR2", "theta"),
  level = 0.95,
  type = c("norm", "basic", "perc"),
  bias.corr = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"LR_boot"}. The current implementation requires bootstrap to construct confidence intervals. Hence, it is not sufficient that \code{object} inherits from \code{"LR"}.}

\item{parm}{A logical value determining whether the confidence interval is computed for the explained Gini coefficient, for the Lorenz-\eqn{R^2} or for the vector of coefficients of the single-index model. Possible values are \code{"Gini"} (default, for the explained Gini),\code{"LR2"} (for the Lorenz-\eqn{R^2}) and \code{"theta"} (for the index coefficients).}

\item{level}{A numeric giving the level of the confidence interval. Default value is 0.95.}

\item{type}{A character string specifying the bootstrap method. Possible values are \code{"norm"}, \code{"basic"} and \code{"perc"}. For more information, see the argument \code{type} of the function \code{\link[boot]{boot.ci}} from the \emph{boot} library.}

\item{bias.corr}{A logical determining whether bias correction should be performed. Only used if \code{type="norm"}. Default is \code{TRUE}.}

\item{...}{Additional arguments.}
}
\value{
The desired confidence interval.
If \code{parm="Gini"} or \code{parm="LR2"}, the output is a vector.
If \code{parm="theta"}, it is a matrix where each row corresponds to a different coefficient.
}
\description{
Provides bootstrap confidence intervals for the explained Gini coefficient, Lorenz-R2 and theta vector for an object of class \code{"LR_boot"}.
}
\examples{
## For examples see example(Lorenz.boot)

}
\seealso{
\code{\link{Lorenz.boot}}, \code{\link[boot]{boot.ci}}
}
