% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Analysis-class.R
\docType{class}
\name{RLum.Analysis-class}
\alias{RLum.Analysis-class}
\alias{get_RLum,RLum.Analysis-method}
\alias{length_RLum,RLum.Analysis-method}
\alias{names_RLum,RLum.Analysis-method}
\alias{set_RLum,RLum.Analysis-method}
\alias{show,RLum.Analysis-method}
\alias{structure_RLum,RLum.Analysis-method}
\title{Class \code{"RLum.Analysis"}}
\usage{
\S4method{show}{RLum.Analysis}(object)

\S4method{set_RLum}{RLum.Analysis}(class, originator,
  protocol = NA_character_, records = list())

\S4method{get_RLum}{RLum.Analysis}(object, record.id = NULL,
  recordType = NULL, curveType = NULL, RLum.type = NULL,
  protocol = "UNKNOWN", get.index = NULL, drop = TRUE, recursive = TRUE)

\S4method{structure_RLum}{RLum.Analysis}(object)

\S4method{length_RLum}{RLum.Analysis}(object)

\S4method{names_RLum}{RLum.Analysis}(object)
}
\arguments{
\item{object}{\code{[show_RLum]}\code{[get_RLum]}\code{[names_RLum]}\code{[length_RLum]}
\code{[structure_RLum]}] an object of class \code{\linkS4class{RLum.Analysis}}
(\bold{required})}

\item{class}{[\code{set_RLum}] \code{\link{character}} (\bold{required}): name of the \code{RLum} class to be created}

\item{originator}{[\code{set_RLum}] \code{\link{character}} (automatic): contains the name
of the calling function (the function that produces this object); can be set manually.}

\item{protocol}{[\code{set_RLum}] \code{\link{character}} (optional): sets protocol type for
analysis object. Value may be used by subsequent analysis functions.}

\item{records}{[\code{set_RLum}] \code{\link{list}} (\bold{required}): list of \code{\linkS4class{RLum.Analysis}} objects

\bold{\code{set_RLum}}:\cr

Returns an \code{\linkS4class{RLum.Analysis}} object.}

\item{record.id}{[\code{get_RLum}] \code{\link{numeric}} or \code{\link{logical}} (optional): IDs of specific records.
If of type \code{logical} the entire id range is assuemd and \code{TRUE} and \code{FALSE} indicates the selection.}

\item{recordType}{[\code{get_RLum}] \code{\link{character}} (optional): record type (e.g., "OSL").
Can be also a vector, for multiple matching, e.g., \code{recordType = c("OSL", "IRSL")}}

\item{curveType}{[\code{get_RLum}] \code{\link{character}} (optional): curve
type (e.g. "predefined" or "measured")}

\item{RLum.type}{[\code{get_RLum}] \code{\link{character}} (optional): RLum object type.
Defaults to "RLum.Data.Curve" and "RLum.Data.Spectrum".}

\item{get.index}{[\code{get_RLum}] \code{\link{logical}} (optional): return a numeric
vector with the index of each element in the RLum.Analysis object.}

\item{drop}{[\code{get_RLum}] \code{\link{logical}} (with default): coerce to the next possible layer
(which are \code{RLum.Data}-objects), \code{drop = FALSE} keeps the original \code{RLum.Analysis}}

\item{recursive}{[\code{get_RLum}] \code{\link{logical}} (with default): if \code{TRUE} (the default)
and the result of the 'get_RLum' request is a single object this object will be unlisted, means
only the object itself and no list containing exactly one object is returned. Mostly this makes things
easier, however, if this method is used within a loop this might undesired.}
}
\value{
\bold{\code{get_RLum}}:\cr

Returns: \cr
(1) \code{\link{list}} of \code{\linkS4class{RLum.Data}} objects or \cr
(2) Single \code{\linkS4class{RLum.Data}} object, if only one object is contained and
\code{recursive = FALSE} or\cr
(3) \code{\linkS4class{RLum.Analysis}} ojects for \code{drop = FALSE} \cr

\bold{\code{structure_RLum}}:\cr

Returns \code{\linkS4class{data.frame}} showing the structure.

\bold{\code{length_RLum}}\cr

Returns the number records in this object.

\bold{\code{names_RLum}}\cr

Returns the names of the record types (recordType) in this object.
}
\description{
Object class to represent analysis data for protocol analysis, i.e. all curves, spectra etc.
from one measurements. Objects from this class are produced, by e.g. \code{\link{read_XSYG2R}},
\code{\link{read_Daybreak2R}}
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Analysis} object

\item \code{set_RLum}: Construction method for \code{\linkS4class{RLum.Analysis}} objects.

\item \code{get_RLum}: Accessor method for RLum.Analysis object.

The slots record.id, recordType, curveType and RLum.type are optional to allow for records
limited by their id (list index number), their record type (e.g. recordType = "OSL")
or object type.

Example: curve type (e.g. curveType = "predefined" or curveType ="measured")

The selection of a specific RLum.type object superimposes the default selection.
Currently supported objects are: RLum.Data.Curve and RLum.Data.Spectrum

\item \code{structure_RLum}: Method to show the structure of an \code{\linkS4class{RLum.Analysis}} object.

\item \code{length_RLum}: Returns the length of the object, i.e., number of stored records.

\item \code{names_RLum}: Returns the names of the \code{\linkS4class{RLum.Data}} objects objects (same as shown with the show method)
}}
\section{Slots}{

\describe{
\item{\code{protocol}}{Object of class \code{\link{character}} describing the applied measurement protocol}

\item{\code{records}}{Object of class \code{\link{list}} containing objects of class \code{\linkS4class{RLum.Data}}}
}}
\note{
The method \code{\link{structure_RLum}} is currently just avaiblable for objects
containing \code{\linkS4class{RLum.Data.Curve}}.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{set_RLum("RLum.Analysis", ...)}.
}

\section{Class version}{
 0.3.0
}
\examples{

showClass("RLum.Analysis")

##set empty object
set_RLum(class = "RLum.Analysis")

###use example data
##load data
data(ExampleData.RLum.Analysis, envir = environment())

##show curves in object
get_RLum(IRSAR.RF.Data)

##show only the first object, but by keeping the object
get_RLum(IRSAR.RF.Data, record.id = 1, drop = FALSE)

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
}
\seealso{
\code{\link{Risoe.BINfileData2RLum.Analysis}},
\code{\linkS4class{Risoe.BINfileData}}, \code{\linkS4class{RLum}}
}
\keyword{classes}
\keyword{methods}

