% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_SAR.CWOSL.R
\name{analyse_SAR.CWOSL}
\alias{analyse_SAR.CWOSL}
\title{Analyse SAR CW-OSL measurements}
\usage{
analyse_SAR.CWOSL(object, signal.integral.min, signal.integral.max,
  background.integral.min, background.integral.max, rejection.criteria = NULL,
  dose.points = NULL, mtext.outer, plot = TRUE, plot.single = FALSE, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Analysis}} (\bold{required}): input
object containing data for analysis, alternatively a \code{\link{list}} of
\code{\linkS4class{RLum.Analysis}} objects can be provided.}

\item{signal.integral.min}{\code{\link{integer}} (\bold{required}): lower
bound of the signal integral. Can be a \code{\link{list}} of \code{\link{integer}s}, if \code{object} is
of type \code{\link{list}}. If the input is vector (e.g., \code{c(1,2)}) the 2nd value will be interpreted
as the minimum signal integral for the Tx curve.}

\item{signal.integral.max}{\code{\link{integer}} (\bold{required}): upper
bound of the signal integral. Can be a \code{\link{list}} of \code{\link{integer}s}, if \code{object} is
of type \code{\link{list}}. If the input is vector (e.g., \code{c(1,2)}) the 2nd value will be interpreted
as the maximum signal integral for the Tx curve.}

\item{background.integral.min}{\code{\link{integer}} (\bold{required}):
lower bound of the background integral. Can be a \code{\link{list}} of \code{\link{integer}s}, if \code{object} is
of type \code{\link{list}}. If the input is vector (e.g., \code{c(1,2)}) the 2nd value will be interpreted
as the minimum background integral for the Tx curve.}

\item{background.integral.max}{\code{\link{integer}} (\bold{required}):
upper bound of the background integral. Can be a \code{\link{list}} of \code{\link{integer}s}, if \code{object} is
of type \code{\link{list}}. If the input is vector (e.g., \code{c(1,2)}) the 2nd value will be interpreted
as the maximum background integral for the Tx curve.}

\item{rejection.criteria}{\code{\link{list}} (with default): provide a named list
and set rejection criteria in \bold{percentage} for further calculation. Can be a \code{\link{list}} in
a \code{\link{list}}, if \code{object} is of type \code{\link{list}}

Allowed arguments are \code{recycling.ratio}, \code{recuperation.rate},
\code{palaeodose.error}, \code{testdose.error} and \code{exceed.max.regpoint = TRUE/FALSE}.
Example: \code{rejection.criteria = list(recycling.ratio = 10)}.
Per default all numerical values are set to 10, \code{exceed.max.regpoint = TRUE}.
Every criterium can be set to \code{NA}. In this value are calculated, but not considered, i.e.
the RC.Status becomes always \code{'OK'}}

\item{dose.points}{\code{\link{numeric}} (optional): a numeric vector
containg the dose points values Using this argument overwrites dose point
values in the signal curves. Can be a \code{\link{list}} of \code{\link{numeric}} vectors,
if \code{object} is of type \code{\link{list}}}

\item{mtext.outer}{\code{\link{character}} (optional): option to provide an
outer margin mtext. Can be a \code{\link{list}} of \code{\link{character}s},
if \code{object} is of type \code{\link{list}}}

\item{plot}{\code{\link{logical}} (with default): enables or disables plot
output.}

\item{plot.single}{\code{\link{logical}} (with default) or
\code{\link{numeric}} (optional): single plot output (\code{TRUE/FALSE}) to
allow for plotting the results in single plot windows. If a numerice vector
is provided the plots can be selected individually, i.e. \code{plot.single =
c(1,2,3,4)} will plot the TL and Lx, Tx curves but not the legend (5) or the
growth curve (6), (7) and (8) belong to rejection criteria plots. Requires
\code{plot = TRUE}.}

\item{\dots}{further arguments that will be passed to the function
\code{\link{plot_GrowthCurve}} or \code{\link{calc_OSLLxTxRatio}}
(supported: \code{background.count.distribution}, \code{sigmab}, \code{sig0}). \bold{Please note} that
if you consider to use the early light subtraction method you should provide your own \code{sigmab}
value!}
}
\value{
A plot (optional) and an \code{\linkS4class{RLum.Results}} object is
returned containing the following elements:
\item{De.values}{\link{data.frame} containing De-values, De-error and
further parameters} \item{LnLxTnTx.values}{\link{data.frame} of all
calculated Lx/Tx values including signal, background counts and the dose
points} \item{rejection.criteria}{\link{data.frame} with values that might
by used as rejection criteria. NA is produced if no R0 dose point exists.}
\item{Formula}{\link{formula} formula that have been used for the growth
curve fitting }\cr The output should be accessed using the function
\code{\link{get_RLum}}.
}
\description{
The function performs a SAR CW-OSL analysis on an
\code{\linkS4class{RLum.Analysis}} object including growth curve fitting.
}
\details{
The function performs an analysis for a standard SAR protocol measurements
introduced by Murray and Wintle (2000) with CW-OSL curves. For the
calculation of the Lx/Tx value the function \link{calc_OSLLxTxRatio} is
used. For \bold{changing the way the Lx/Tx error is calculated} use the argument
\code{background.count.distribution} and \code{sigmab}, which will be passed to the function
\link{calc_OSLLxTxRatio}.\cr\cr

\bold{Argument \code{object} is of type \code{list}}\cr\cr

If the argument \code{object} is of type \code{\link{list}} containing \bold{only}
\code{\linkS4class{RLum.Analysis}} objects, the function re-calls itself as often as elements
are in the list. This is usefull if an entire measurement wanted to be analysed without
writing separate for-loops. To gain in full control of the parameters (e.g., \code{dose.points}) for
every aliquot (corresponding to one \code{\linkS4class{RLum.Analysis}} object in the list), in
this case the arguments can be provided as \code{\link{list}}. This \code{list} should
be of similar length as the \code{list} provided with the argument \code{object}, otherwise the function
will create an own list of the requested lenght. Function output will be just one single \code{\linkS4class{RLum.Results}} object.

Please be careful when using this option. It may allow a fast an efficient data analysis, but
the function may also break with an unclear error message, due to wrong input data.\cr\cr

\bold{Working with IRSL data}\cr\cr

The function was originally designed to work just for 'OSL' curves,
following the principles of the SAR protocol. An IRSL measurement protocol
may follow this procedure, e.g., post-IR IRSL protocol (Thomsen et al.,
2008). Therefore this functions has been enhanced to work with IRSL data,
however, the function is only capable of analysing curves that follow the
SAR protocol structure, i.e., to analyse a post-IR IRSL protocol, curve data
have to be pre-selected by the user to fit the standards of the SAR
protocol, i.e., Lx,Tx,Lx,Tx and so on. \cr

Example: Imagine the measurement contains pIRIR50 and pIRIR225 IRSL curves.
Only one curve type can be analysed at the same time: The pIRIR50 curves or
the pIRIR225 curves.\cr\cr

\bold{Supported rejection criteria}\cr\cr \sQuote{recycling.ratio}:
calculated for every repeated regeneration dose point.\cr

\sQuote{recuperation.rate}: recuperation rate calculated by comparing the
Lx/Tx values of the zero regeneration point with the Ln/Tn value (the Lx/Tx
ratio of the natural signal). For methodological background see Aitken and
Smith (1988).\cr

\sQuote{testdose.error}: set the allowed error for the testdose, which per
default should not exceed 10\%. The testdose error is calculated as Tx_net.error/Tx_net.

\sQuote{palaeodose.error}: set the allowed error for the De value, which per
default should not exceed 10\%.
}
\note{
This function must not be mixed up with the function
\code{\link{Analyse_SAR.OSLdata}}, which works with
\link{Risoe.BINfileData-class} objects.\cr

\bold{The function currently does only support 'OSL' or 'IRSL' data!}
}
\section{Function version}{
 0.7.9 (2017-01-24 21:10:47)
}

\examples{

##load data
##ExampleData.BINfileData contains two BINfileData objects
##CWOSL.SAR.Data and TL.SAR.Data
data(ExampleData.BINfileData, envir = environment())

##transform the values from the first position in a RLum.Analysis object
object <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos=1)

##perform SAR analysis and set rejection criteria
results <- analyse_SAR.CWOSL(
object = object,
signal.integral.min = 1,
signal.integral.max = 2,
background.integral.min = 900,
background.integral.max = 1000,
log = "x",
fit.method = "EXP",
rejection.criteria = list(
  recycling.ratio = 10,
  recuperation.rate = 10,
  testdose.error = 10,
  palaeodose.error = 10,
  exceed.max.regpoint = TRUE)
)

##show De results
get_RLum(results)

##show LnTnLxTx table
get_RLum(results, data.object = "LnLxTnTx.table")

} 

\section{How to cite}{
Kreutzer, S. (2017). analyse_SAR.CWOSL(): Analyse SAR CW-OSL measurements. Function version 0.7.9. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.3. https://CRAN.R-project.org/package=Luminescence
}

\references{
Aitken, M.J. and Smith, B.W., 1988. Optical dating: recuperation
after bleaching. Quaternary Science Reviews 7, 387-393.

Duller, G., 2003. Distinguishing quartz and feldspar in single grain
luminescence measurements. Radiation Measurements, 37 (2), 161-165.

Murray, A.S. and Wintle, A.G., 2000. Luminescence dating of quartz using an
improved single-aliquot regenerative-dose protocol. Radiation Measurements
32, 57-73.

Thomsen, K.J., Murray, A.S., Jain, M., Boetter-Jensen, L., 2008. Laboratory
fading rates of various luminescence signals from feldspar-rich sediment
extracts. Radiation Measurements 43, 1474-1486.
doi:10.1016/j.radmeas.2008.06.002
}
\seealso{
\code{\link{calc_OSLLxTxRatio}}, \code{\link{plot_GrowthCurve}},
\code{\linkS4class{RLum.Analysis}}, \code{\linkS4class{RLum.Results}}
\code{\link{get_RLum}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\keyword{datagen}
\keyword{plot}
