% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SingleGrainDisc.R
\name{plot_SingleGrainDisc}
\alias{plot_SingleGrainDisc}
\title{Plot a disc with its values}
\usage{
plot_SingleGrainDisc(
  object,
  show_coordinates = FALSE,
  show_location_ids = FALSE,
  show_neighbours = FALSE,
  show_positioning_holes = TRUE,
  df_neighbours = NULL,
  ignore_borders = FALSE,
  str_transform = "sqrt",
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Results} or \link{numeric} (\strong{required}): the values
to show, should have length 100.}

\item{show_coordinates}{\link{logical} (\emph{with default}): Show coordinates (1..10)
in x and in y direction. Defaults to \code{FALSE}.}

\item{show_location_ids}{\link{logical} (\emph{with default}): Show id with every
grain location (1..100). Defaults to \code{FALSE}.}

\item{show_neighbours}{\link{logical}  (\emph{with default}): Show which
neighbour connections are taken into account if calculating Moran's I.
This makes sense when there are \code{NA} observations, or when a non-standard
neighbour setting is defined.}

\item{show_positioning_holes}{\link{logical} (\emph{with default}): Show the 3
positioning holes for orientation. Defaults to \code{TRUE}.}

\item{df_neighbours}{\link{data.frame} (\emph{with default}): only relevant if
\code{show_neighbours} is \code{TRUE}. Data frame indicating which borders to
consider, and their respective weights (see the description provided for
\link{calc_MoransI}). If \code{NULL} (default), this is constructed automatically by
the internal function \code{.get_Neighbours}.}

\item{ignore_borders}{\link{logical} (\emph{with default}): whether only grain
locations that do not lie on the border of the disc should be considered
(\code{FALSE} by default). Thus if \code{TRUE}, only the inner 8x8 grain locations
rather than the full 10x10 are considered. Ignored if \code{df_neighbours} is
not \code{NULL} or if \code{show_neighbours = FALSE}.}

\item{str_transform}{\link{character} (\emph{with default}): The observed value of each individual grain is
reflected in the size of a triangle (or other dot-like element). To account for large value differences,
the transformation from value to triangle size can be \code{"lin"} (linear), \code{"log"} (logarithmic) and \code{"sqrt"}
(square root). Defaults to \code{"sqrt"}, so that the surface is linear to the value. Note that
the log and sqrt transformations can come with an addition to avoid negative values. When the legend
is shown, the actual lower, middle and upper values are printed.}

\item{...}{other arguments to be given to the base R plot function, such
as \code{main}, \code{col} and \code{pch}. \code{legend} can be used to enable/disable the
legend (\code{FALSE} by default).}
}
\description{
Shows a schematic representation of the physical appearance
of one disc (one position in the reader)
and illustrates the measured or calculated values per grain location.
}
\details{
Depending of the available plotting space, some optional elements might have not enough room
to be displayed. As this function is wrapped around the base plot function, one can also choose to add elements
manually.
}
\examples{

plot_SingleGrainDisc(1:100)

} 

\section{How to cite}{
Boer, A.d., Steinbuch, L., 2025. plot_SingleGrainDisc(): Plot a disc with its values. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\references{
de Boer, A-M., Steinbuch, L., Heuvelink, G.B.M., Wallinga, J., 2025.
A novel tool to assess crosstalk in single-grain luminescence detection.
Submitted.
}
\author{
Anna-Maartje de Boer, Luc Steinbuch, Wageningen University & Research, 2025
, RLum Developer Team}
