/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import java.util.Arrays;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.utils.StringUtils;

public class ClusterGrowthAction {
    protected Type type = null;
    protected int[] nodes = null;
    private static ClusterGrowthAction cachedTerminateAction = new ClusterGrowthAction(Type.TERMINATE);

    protected ClusterGrowthAction(Type type) {
        this.type = type;
    }

    public static ClusterGrowthAction addition(int index) {
        ClusterGrowthAction result = new ClusterGrowthAction(Type.ADD);
        result.nodes = new int[1];
        result.nodes[0] = index;
        return result;
    }

    public static ClusterGrowthAction addition(int[] array) {
        ClusterGrowthAction result = new ClusterGrowthAction(Type.ADD);
        result.nodes = Arrays.copyOf(array, array.length);
        return result;
    }

    public static ClusterGrowthAction removal(int index) {
        ClusterGrowthAction result = new ClusterGrowthAction(Type.REMOVE);
        result.nodes = new int[1];
        result.nodes[0] = index;
        return result;
    }

    public static ClusterGrowthAction removal(int[] array) {
        ClusterGrowthAction result = new ClusterGrowthAction(Type.REMOVE);
        result.nodes = Arrays.copyOf(array, array.length);
        return result;
    }

    public static ClusterGrowthAction terminate() {
        return cachedTerminateAction;
    }

    public Type getType() {
        return this.type;
    }

    public void executeOn(MutableNodeSet nodeSet) {
        if (this.type == Type.ADD) {
            for (int node : this.nodes) {
                nodeSet.add(node);
            }
            return;
        }
        if (this.type == Type.REMOVE) {
            for (int node : this.nodes) {
                nodeSet.remove(node);
            }
            return;
        }
    }

    public String toString() {
        Integer[] nodes;
        StringBuilder sb = new StringBuilder();
        if (this.nodes == null) {
            nodes = new Integer[]{};
        } else {
            nodes = new Integer[this.nodes.length];
            for (int i = 0; i < this.nodes.length; ++i) {
                nodes[i] = this.nodes[i];
            }
        }
        sb.append(this.getType().toString());
        sb.append(" {");
        sb.append(StringUtils.join(Arrays.asList(nodes).iterator(), ", "));
        sb.append("}");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADD,
        REMOVE,
        TERMINATE;

    }
}

