% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTiTvPlot.R
\name{generateTiTvPlot}
\alias{generateTiTvPlot}
\title{Function to plot the frequency of Transitions and Transversions of gene mutations}
\usage{
generateTiTvPlot(
  maf,
  use_silent_mutations = FALSE,
  sampleOrder = NULL,
  color = NULL,
  showBarcodes = FALSE,
  textSize = 15,
  baseFontSize = 15,
  axisTextSize = 10
)
}
\arguments{
\item{maf}{A MAF object}

\item{use_silent_mutations}{Include synonymous variants in analysis. Defaults to FALSE.}

\item{sampleOrder}{Sample names in which the barplot should be ordered. Default NULL.}

\item{color}{named vector of colors for each coversion class.}

\item{showBarcodes}{Whether to include sample names for barplot.}

\item{textSize}{fontsize if showBarcodes is TRUE. Default 15 (in pts).}

\item{baseFontSize}{font size of axis title. Default 15 (in pts).}

\item{axisTextSize}{text size x and y tick labels. Default 10 (in pts).}
}
\value{
List of objects consisting of different TiTv plots.
}
\description{
This function plot the frequency of Transitions and Transversions of gene mutations
}
\examples{
library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
plots<-generateTiTvPlot(read.maf(maf))

}
\author{
Ashish Jain, Mayank Tandon
}
