% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualitiyMetrics.R
\name{calculateVPrime}
\alias{calculateVPrime}
\title{Calculate V'-Factor}
\usage{
calculateVPrime(res, internal = TRUE)
}
\arguments{
\item{res}{Object of class MALDIassay}

\item{internal}{Logical, currently only the internal implementation,
using \code{nConc} top and bottom concentrations, is implemented.}
}
\value{
Numeric vector of V'-factors
}
\description{
Calculate V'-Factor
}
\details{
The V'-factor is a generalization of the Z'-factor to a dose-response curve.
See \href{https://www.ncbi.nlm.nih.gov/books/NBK126174/pdf/Bookshelf_NBK126174.pdf}{M.-A. Bray and A. Carpenter, Advanced assay development guidelines for image-based high content screening and analysis} for details.
It is defined as:
\deqn{V' = 1 - 6 * \sigma_f/|\mu_p - \mu_n|}

with

\deqn{\sigma_f = \sqrt{1/N * \sum{y_fit - y_measured}^2}}

In other words, \eqn{\sigma_f} is the standard deviation of residuals.

Note, we do not need to estimate the variance for the mean of the positive and negative value.
So, this function uses the top and bottom asymptote directly instead of taking the top and bottom concentrations in consideration.
}
\examples{
# see example for `fitCurve()` to see how this data was generated
data(Blank2022res)

calculateVPrime(Blank2022res) 
}
