% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MANOVA-function.R
\name{MANOVA}
\alias{MANOVA}
\title{Tests for Multivariate Data in Semi-Parametric Factorial Designs}
\usage{
MANOVA(formula, data, subject, iter = 10000, alpha = 0.05,
  resampling = "paramBS", CPU)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side 
contains the response variable and the right hand side contains the factor 
variables of interest. An interaction term must be specified.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}.}

\item{subject}{the column name of the subjects in the data.}

\item{iter}{The number of iterations used for calculating the resampled 
statistic. The default option is 10000.}

\item{alpha}{A number specifying the significance level; the default is 0.05.}

\item{resampling}{The resampling method to be used, one of "paramBS"
(parametric bootstrap approach) and "WildBS" (wild bootstrap approach with
Rademacher weights). The Wild Bootstrap is applied to both test statistics.}

\item{CPU}{The number of cores used for parallel computing. If omitted, cores are
detected via \code{\link[parallel]{detectCores}}.}
}
\value{
A \code{MANOVA} object containing the following components: 
  \item{Descriptive}{Some descriptive statistics of the data for all factor 
  level combinations. Displayed are the number of individuals per factor 
  level combination and the vector of means (one column per dimension).}
  \item{Covariance}{The estimated covariance matrix.} 
  \item{WTS}{The value of the WTS along with degrees of freedom of the
  central chi-square distribution and p-value.} 
  \item{ATS}{The value of the
  ATS, degrees of freedom of the central F distribution and the corresponding
  p-value.} 
  \item{resampling}{p-values for the test statistic based on the
  chosen resampling approach.}
}
\description{
The MANOVA function calculates the Wald-type statistic (WTS), the ANOVA-type 
statistic (ATS) as well as resampling versions of these test statistics for 
semi-parametric multivariate data.
}
\details{
The MANOVA() function provides the Wald-type statistic as well as
  the ANOVA-type statistic for multivariate designs with metric data as described in 
  Konietschke et al. (2015). These tests are even applicable for non-normal error terms, 
  different sample sizes and/or heteroscedastic variances.
  They are implemented for designs with an arbitrary number of
  crossed factors or for nested designs. In addition to the asymptotic
  p-values, it also provides p-values based on resampling approaches.
}
\section{NOTE}{
 The number of resampling iterations has been set to 100 in the examples due to run time 
restrictions on CRAN. Usually it is recommended to use at least 1000 iterations.
}
\examples{
data(EEG)
EEG_mod <- MANOVA(resp ~ sex * diagnosis, 
                    data = EEG, subject = "id", resampling = "paramBS", 
                    alpha = 0.05, iter = 100, CPU = 1)
summary(EEG_mod)

}
\references{
Konietschke, F., Bathke, A. C., Harrar, S. W. and Pauly, M. (2015). 
  Parametric and nonparametric bootstrap methods for general MANOVA. Journal 
  of Multivariate Analysis, 140, 291-301.
  
  Friedrich, S, Brunner, E and Pauly, M (2016). Permuting longitudinal data 
  despite all the dependencies. arXiv preprint arXiv:1509.05570v2
  
   Bathke, A., Friedrich, S., Konietschke, F., Pauly, M., Staffen, W., Strobl, N. and Hoeller, Y. (2016). Using EEG, SPECT, and Multivariate Resampling Methods
to Differentiate Between Alzheimer's and other Cognitive Impairments. arXiv preprint arXiv:1606.09004.
  
  Friedrich, S., Konietschke, F., Pauly, M.(2016). GFD - An 
  R-package for the Analysis of General Factorial Designs. Accepted for publication in 
  Journal of Statistical Software.
}
\seealso{
\code{\link{RM}}
}

