% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_01_5_ComputePSI_RI.R
\name{ComputePSI.RI}
\alias{ComputePSI.RI}
\title{Compute Retained-intron (RI) Percent Spliced-in (PSI) Values}
\usage{
ComputePSI.RI(MarvelObject, CoverageThreshold, CountsPerBaseIntronFile,
  thread)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}

\item{CountsPerBaseIntronFile}{Data frame containing per base coverage of introns. First column should be named \code{coord.intron} and indicate the per base intron position in the form of chr:position. Subsequent columns should contain the per base coverage for each sample. These counts can be deteted using external softwares such as Bedtools etc..}

\item{thread}{Numeric value. Set number of threads.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to two new slots. \code{$SpliceFeatureValidated$RI} contains the validated splicing event metadata. \code{$PSI$RI} contains the computed PSI values for the validated splicing events.
}
\description{
\code{ComputePSI.RI} computes percent spliced-in (PSI) retained intron (RI) splicing event.
}
\details{
This function computes the PSI for each RI splicing event. Splicing events provided in \code{SpliceFeature} data frame will first be cross-checked against the splice junctions provided in \code{SpliceJunction} data frame. Only events whose junctions are found in \code{SpliceJunction} are retained. Formula for computing PSI is the normalized intron coverage divided by the total number of reads supporting both included and excluded isoforms. Normalized intron coverage is computed by taking the total coverage over the intronic region adjusted (divided) by the intron length.
}
\examples{
path_to_file <- system.file("extdata/Data", "Counts_per_Base_Validated.txt",
                            package="MARVEL")
df.intron.counts <- read.table(path_to_file, sep="\\t", header=TRUE,
                               stringsAsFactors=FALSE, na.strings="NA")

marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

marvel <- ComputePSI.RI(MarvelObject=marvel,
                        CoverageThreshold=10,
                        CountsPerBaseIntronFile=df.intron.counts,
                        thread=1
                        )

marvel$SpliceFeatureValidated$RI
marvel$PSI$RI[,1:5]
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
