% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_03_PREPROCESS_3_2_CheckAlignment_Gene.R
\name{CheckAlignment.Exp}
\alias{CheckAlignment.Exp}
\title{Check Alignment for gene data}
\usage{
CheckAlignment.Exp(MarvelObject)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} or \code{SubsetSamples} function.}
}
\value{
An object of class S3. The original \code{MarvelObject$SplicePheno}, \code{MarvelObject$SpliceFeature}, and \code{MarvelObject$PSI} are updated
}
\description{
\code{CheckAlignment} checks if the metadata aligns with the columns and rows of the matrix for gene data.
}
\details{
This function checks if the \code{sample.id} column of \code{MarvelObject$GenePheno} aligns with the column names of matrix in \code{MarvelObject$Exp}. To do this, the function subset overlapping sample IDs present in both the phenoData and matrix. This function also checks if the \code{gene_id} column of the \code{MarvelObject$GeneFeature} aligns with the \code{gene_id} column of matrix \code{MarvelObject$Exp}. To do this, the function subset overlappign gene IDs present in both the featureData and matrix.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- CheckAlignment.Exp(MarvelObject=marvel)
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
