% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_03_PREPROCESS_4_TransformGeneValues.R
\name{TransformExpValues}
\alias{TransformExpValues}
\title{Transform Gene Expression Values}
\usage{
TransformExpValues(
  MarvelObject,
  offset = 1,
  transformation = "log2",
  threshold.lower = 1
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject}, \code{SubsetSamples} or \code{CheckAlignment} function.}

\item{offset}{Numeric value. To indicate the value to add to the expression values before log transformation. The only option for this argument is 1.}

\item{transformation}{Character string. To indicate the type of transformation to use on the expression values after offsetting the values. The only option for this argument is \code{log2}.}

\item{threshold.lower}{Numeric value. To indicate the value below which the expression values will be censored, i.e. re-coded as 0, after offsetting and transforming the values. The only option for this argument is \code{1}.}
}
\value{
An object of class S3. The original matirx in \code{MarvelObject$Exp} is replaced with the new offset-ed, transformed, and censored values.
}
\description{
\code{TransformExpValues} transforms gene expression values.
}
\details{
This function transforms gene expression values prior to downstream analysis, such as differential expression analysis. The values provided to this function are assumed to have already been normalised, e.g. normalised by per-cell library size and gene length and then multiplied by a scale factor in the case of transcript per million (TPM).
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- TransformExpValues(MarvelObject=marvel)
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
