% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_07_PREDICT_NMD_2_2_FindPTC_SE_NegStrand.R
\name{FindPTC.SE.NegStrand}
\alias{FindPTC.SE.NegStrand}
\title{Find Premature Terminal Codon (PTC) for Skipped-Exon (SE) Located on the Negative Strand of the Transcript}
\usage{
FindPTC.SE.NegStrand(MarvelObject, tran_id, gene_id)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues.PSI} and \code{ParseGTF} function.}

\item{tran_id}{Character string. Vector of \code{tran_id} to look for PTCs.}

\item{gene_id}{Character string. Vector of \code{gene_id} corresponding to the \code{tran_id} argument.#'}
}
\value{
A data frame of transcripts containing splicing events meeting the \code{psi.de.sig} and \code{psi.de.diff} criteria are categorised based on the presence or absence of PTCs.
}
\description{
\code{FindPTC.SE.NegStrand} finds PTC(s) introduced by alternative exons into protein-coding transcripts.
}
\details{
This function finds PTC(s) introduced by alternative exons into protein-coding transcripts. It also records the distance between a PTCs and the final splice junction for a given protein-coding transcript. Non-protein-coding transcripts or transcripts in which splicing events are located outside of the transcripts' open-reading frame (ORF) are not analysed for PTCs but are noted.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Retrieve features
df <- marvel$DE$PSI$Table
df <- df[which(df$event_type=="SE"), ]
df <- df[grep(":-@", df$tran_id, fixed=TRUE), ]
tran_id <- df$tran_id[1]
gene_id <- df$gene_id[1]

# Run example
results <- FindPTC.SE.NegStrand(MarvelObject=marvel,
                                tran_id=tran_id,
                                gene_id=gene_id
                                )

# Check output
results
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
