% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_06_MODALITY_ANALYSIS_2_2_PropModality_Bar.R
\name{PropModality.Bar}
\alias{PropModality.Bar}
\title{Modality proportion broken down by event type}
\usage{
PropModality.Bar(
  MarvelObject,
  modality.column,
  modality.type,
  event.type,
  xlabels.size = 8,
  zoom = FALSE,
  yinterval = NULL,
  prop.test,
  prop.adj
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{AssignModality} function.}

\item{modality.column}{Character string. Can take the value \code{"modality"}, \code{"modality.var"} or \code{"modality.bimodal.adj"}. Please refer to \code{AssignModality} function help page for more details.}

\item{modality.type}{Character string. \code{basic} indicates that only the main modalities (included, excluded, bimodal, middle, multimodal) are analysed. Sub-modalities (primary and dispersed) will be merged. \code{extended} indicates that both main and sub-modalities are analysed. Sub-modalities will not be merged.}

\item{event.type}{Character string. To indicate which event type to analyse. Can take the value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"} or \code{"A3SS"}. Specify \code{"all"} to include all event types.}

\item{xlabels.size}{Numeric value. Size of x-axis labels as per \code{ggplot2} function. Default is 8.}

\item{zoom}{Logical value. If set to \code{TRUE}, users can specify the range of the y-axis using \code{yinterval} argument. Useful when scrutinasing low-frequency event types, e.g. middle and multimodal.}

\item{yinterval}{Logical value. Only applicable when \code{zoom} is set to \code{TRUE}.}

\item{prop.test}{Character string. Only applicable when \code{across.event.type} set to \code{TRUE}. \code{chisq} Chi-squared test used to compare the proportion of modalities across the different event splicing type. \code{fisher} Fisher test used to compare the proportion of modalities across the different splicing event type.}

\item{prop.adj}{Character string. Only applicable when \code{across.event.type} set to \code{TRUE}. Adjust p-values generated from \code{prop.test} for multiple testing. Options available as per \code{p.adjust} function.}
}
\value{
An object of class S3 containing new slots \code{MarvelObject$Modality$Prop$BarChart$Table} and \code{MarvelObject$Modality$Prop$BarChart$Stats}.
}
\description{
Tabulates and plots the proportion of each modality broken down by splicing event type.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- PropModality.Bar(MarvelObject=marvel.demo,
                                modality.column="modality.bimodal.adj",
                                modality.type="extended",
                                event.type=c("SE", "MXE", "RI", "A5SS", "A3SS", "AFE", "ALE"),
                                prop.test="fisher",
                                prop.adj="fdr"
                                )

# Check outputs
head(marvel.demo$Modality$Prop$BarChart$Table)
marvel.demo$Modality$Prop$BarChart$Plot
marvel.demo$Modality$Prop$BarChart$Stats
}
