% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_lt.R
\name{givens_orth}
\alias{givens_orth}
\title{Givens orthogonalisation}
\usage{
givens_orth(X, nullspace = FALSE)
}
\arguments{
\item{X}{a numeric matrix with ncol(X) <= nrow(X)}

\item{nullspace}{logical: do you want an orthogonal basis for the null space?}
}
\value{
A list with components Q, R, as normally defined, and if nullspace is TRUE
   a further component N giving the basis for the requested null space of X
}
\description{
Orthogonalization using Givens' method.
}
\examples{
set.seed(1234)
X <- matrix(rnorm(7*6), 7)
givens_orth(X, nullspace = TRUE)
}
