% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kc_house_data.R
\docType{data}
\name{kc_house_data}
\alias{kc_house_data}
\title{House price in King County, USA}
\format{A data frame with 21613 rows and 19 variables}
\source{
\url{https://www.kaggle.com/harlfoxem/housesalesprediction}
}
\description{
A data set contains 21613 obervations with 19 features plus house price. The names of the columns are given below.
\itemize{
  \item id
  \item date: Date house was sold(String)
  \item price: Price of the sold house
  \item bedrooms: Numer of Bedrooms
  \item bathrooms: Numer of bathrooms
  \item sqft_living: Square footage of the living room
  \item sqrt_log: Square footage of the log
  \item floors: Total floors in the house
  \item waterfront: Whether the house has a view a waterfront(1: yes, 0: not)
  \item view: unknown
  \item condtion: Condition of the house
  \item grade: unknown
  \item sqft_above: Square footage of house apart from basement
  \item sqft_basement: Square footage of the basement
  \item yr_built: Built year
  \item yr_renovated: Year when the house was renovated
  \item zipcode: zipcode of the house
  \item lat: Latitude coordinate
  \item long Longitude coordinate
  \item sqft_living15: Living room area in 2015(implies some renovations)
  \item sqrt_lot15: Lot area in 2015(implies some renovations)
}
}
\examples{
data(kc_house_data)
#convert date in string to date in numeric value
kc_house_data[,2]=sapply(kc_house_data[,2],as.double)
train = sample(1:21613)[1:1000]
x.train = as.matrix(kc_house_data[train,c(2,4:21)]) #exclude id, house price
y.train = as.matrix(kc_house_data[train,3]) # house price
x.test  = as.matrix(kc_house_data[-train,c(2,4:21)])
y.test  = as.matrix(kc_house_data[-train,3])
}
\keyword{datasets}
