% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBValidation.R
\name{MBValidation}
\alias{MBValidation}
\title{Cross-Validation of MBPLS or MBWCov models}
\usage{
MBValidation(
  res,
  ncomp.max = min(res$call$ncomp, nrow(res$call$X) - 2, ncol(X)),
  method = "LOO",
  nboot = 1000,
  graph = TRUE,
  size.graph = 2.25
)
}
\arguments{
\item{res}{An object resulting from \code{\link{MBPLS}} or \code{\link{MBWCov}}.}

\item{ncomp.max}{The maximum number of components to be investigated in the CV procedure.}

\item{method}{Either "LOO" or "OOB". Default is LOO.}

\item{nboot}{Number of bootstrap samples to be generated in case of OOB CV.}

\item{graph}{Logical. Should the results be plotted? Default is TRUE.}

\item{size.graph}{If \emph{graph=TRUE}, the overall size of labels, points, etc.}
}
\value{
A matrix with two rows (MSEP and std.error) and \emph{ncomp.max+1} columns. The +1 column corresponds to the null model (Dim.0) where Y is predicted by its empirical average on the training sample.
}
\description{
Computes MSEP and corresponding standard error based on Leave One Out (LOO) or Out Of Bag (OOB) Cross-Validation (CV) by number of components of a MBPLS or MBWCov model from \code{\link{MBPLS}} or \code{\link{MBWCov}}.
}
\examples{
# With MBPLS

data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbpls <- MBPLS(X, Y, block, name.block = names(block))
MBValidation(res.mbpls)

# With MBWCov

data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbwcov <- MBWCov(X, Y, block, name.block = names(block))
MBValidation(res.mbwcov)

}
\seealso{
\code{\link{predict.MBPLS}}   \code{\link{predict.MBWCov}}
}
