\name{Cor.Mat.Lomax}
\alias{Cor.Mat.Lomax}
\docType{data}
\title{ Correlation matrix for Lomax (1983) data set}
\description{
Correlation matrix for Lomax (1983) data set
}
\usage{data(Cor.Mat.Lomax)}
%\format{}

\details{
Variables 1 through 14 in the correlation matrix are, respectively: \tabular{l}{
Variables \cr
(1) DRS-consonant sounds \cr
(2) DRS-consonant blends and diagraphs \cr
(3) DRS-common syllables or phonograms \cr
(4) DRS-blending \cr
(5) WRAT-total raw score \cr
(6) DRS-total correct both lists \cr
(7) DRS-total words read correct oral \cr
(8) DRS-wpm first oral passage \cr
(9) DRS-wpm first silent passage \cr
(10) DRS-mean wpm oral passages read \cr
(11) DRS-mean wpm silent passages read \cr
(12) DRS-total correct oral comprehension\cr
(13) DRS-total correct silent comprehension\cr
(14) CTBS-comprehension ESS scores
}

DRS refers to Diagnostic Reading Scales, WRAT refers to Wide Range Achievement Test, and CTBS refers to
Comprehensive Tests of basic skills.  

The model was designed to study the causal relationship between the phonological, word recognition, reading rate, and comprehension components of the reading
process. There are four latent variables in the model: (a) phonological; (b) word recognition; (c) reading rate; 
(d) reading comprehension.

Phonological is indicated by (a) DRS-consonant sounds; (b) DRS-consonant blends and diagraphs; (c) DRS-common
 syllables or phonograms; (d) DRS-blending.

Word recognition is indicated by (a) WRAT-total raw score; (b) DRS-total correct both lists; (c) DRS-total
 words read correct oral

Reading rate is indicated by (a) DRS-wpm first oral passage; (b) DRS-wpm first silent passage; 
(c) DRS-mean wpm oral passages read; (d) DRS-mean wpm silent passages read.

Reading comprehension is indicated by (a) DRS-total correct oral comprehension; (b) DRS-total correct 
silent comprehension; (c) CTBS-comprehension ESS scores.
}
\source{
Lomax, R. G. (1983). Applying structural modeling to some component processes of reading comprehension
development. \emph{Journal of Experimental Education, 52} (1), 33-40.
}
\references{
Lomax, R. G. (1983). Applying structural modeling to some component processes of reading comprehension
development. \emph{Journal of Experimental Education, 52} (1), 33-40.
}
%\examples{}
\keyword{datasets}
