% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.functions.R
\name{dspline}
\alias{dspline}
\title{Spline dose-response functions}
\usage{
dspline(
  type = "bs",
  knots = 1,
  degree = 1,
  beta.1 = "rel",
  beta.2 = "rel",
  beta.3 = "rel",
  beta.4 = "rel"
)
}
\arguments{
\item{type}{The type of spline. Can take \code{"bs"} (\href{https://mathworld.wolfram.com/B-Spline.html}{B-spline}),
\code{"ns"} (\href{https://mathworld.wolfram.com/CubicSpline.html}{natural cubic spline}),
or \code{"ls"} (piecewise linear spline)}

\item{knots}{The number/location of spline internal knots. If a single number is given it indicates the number of knots (they will
be equally spaced across the range of doses \emph{for each agent}). If a numeric vector is given it indicates the location of the knots.}

\item{degree}{The degree of the piecewise B-spline polynomial - e.g. \code{degree=1} for linear, \code{degree=2} for quadratic, \code{degree=3} for cubic.}

\item{beta.1}{Pooling for the 1st coefficient. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{beta.2}{Pooling for the 2nd coefficient. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{beta.3}{Pooling for the 3rd coefficient. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{beta.4}{Pooling for the 4th coefficient. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}
}
\value{
An object of \code{class("dosefun")}
}
\description{
Used to fit B-splines, natural cubic splines, and
piecewise linear splines\insertCite{perperoglu2019}{MBNMAdose}.
}
\section{Dose-response parameters}{
\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Implies that \emph{relative} effects should be pooled for this dose-response parameter separately for each agent in the network. \cr
   \code{"common"} \tab Implies that all agents share the same common effect for this dose-response parameter. \cr
   \code{"random"} \tab Implies that all agents share a similar (exchangeable) effect for this dose-response parameter. This approach allows for modelling of variability between agents. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this dose-response parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific dose-response parameters (e.g. Hill parameters in Emax functions) to a single value. \cr
}


When relative effects are modelled on more than one dose-response parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
This prior can be made slightly more informative by specifying the scale matrix \code{omega}
and by changing the degrees of freedom of the inverse-Wishart prior
using the \code{priors} argument in \code{mbnma.run()}.
}

\examples{
# Second order B spline with 2 knots and random effects on the 2nd coefficient
dspline(type="bs", knots=2, degree=2,
  beta.1="rel", beta.2="rel")

# Piecewise linear spline with knots at 0.1 and 0.5 quantiles
# Single parameter independent of treatment estimated for 1st coefficient
#with random effects
dspline(type="ls", knots=c(0.1,0.5),
  beta.1="random", beta.2="rel")

}
\references{
\insertAllCited
}
