% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{getjagsdata}
\alias{getjagsdata}
\title{Prepares data for JAGS}
\usage{
getjagsdata(
  data.ab,
  class = FALSE,
  sdscale = FALSE,
  regress = NULL,
  regress.effect = "common",
  likelihood = check.likelink(data.ab)$likelihood,
  link = check.likelink(data.ab)$link,
  level = "agent",
  fun = NULL,
  nodesplit = NULL
)
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{dose} Numeric data indicating the dose (must take positive values)
\item \code{agent} Agent identifiers (can be numeric, factor or character)
\item \code{y} Numeric data indicating the aggregate response for a continuous outcome. Required for
continuous data.
\item \code{se} Numeric data indicating the standard error for a given observation. Required for
continuous data.
\item \code{r} Numeric data indicating the number of responders within a study arm. Required for
binomial or poisson data.
\item \code{n} Numeric data indicating the total number of participants within a study arm. Required for
binomial data or when modelling Standardised Mean Differences
\item \code{E} Numeric data indicating the total exposure time for participants within a study arm. Required
for poisson data.
\item \code{class} An optional column indicating a particular class code. Agents with the same identifier
must also have the same class code.
\item \code{standsd} An optional column of numeric data indicating reference SDs used to standardise
treatment effects when modelling using Standardised Mean Differences (SMD).
}}

\item{class}{A boolean object indicating whether or not \code{data.ab} contains
information on different classes of treatments}

\item{sdscale}{Logical object to indicate whether to write a model that specifies a reference SD
for standardising when modelling using Standardised Mean Differences. Specifying \code{sdscale=TRUE}
will therefore only modify the model if link function is set to SMD (\code{link="smd"}).}

\item{regress}{A formula of effect modifiers (variables that
interact with the treatment effect) to incorporate using Network Meta-Regression
(E.g. \code{~ Population + Age}). All variables in the formula are modelled as interacting
with the treatment effect (i.e. prognostic variables cannot be included in this way).
Effects modifiers must be named variables in \code{network$data.ab} and must be identical
within a study. Factor and character effect modifiers will be converted to a series of
named dummy variables.}

\item{regress.effect}{Indicates whether effect modification should be assumed to be
\code{"common"} (assumed to be equal versus Placebo throughout the network),
\code{"random"} (assumed to be exchangeable versus Placebo throughout the network),
\code{"agent"} (assumed to be equal versus Placebo within each agent), or
\code{"class"} (assumed to be equal versus Placebo within each class).}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{link}{A string indicating the link function to use in the model. Can take any link function
defined within JAGS (e.g. \code{"logit"}, \code{"log"}, \code{"probit"}, \code{"cloglog"}), be assigned the value \code{"identity"} for
an identity link function, or be assigned the value \code{"smd"} for modelling Standardised Mean Differences using an
identity link function. If left as \code{NULL} the link function will be automatically assigned based
on the likelihood.}

\item{level}{Can take either \code{"agent"} to indicate that data should be at the agent-
level (for MBNMA) or \code{"treatment"} to indicate that data should be at the treatment-
level (for NMA)}

\item{fun}{An object of \code{class("dosefun")} that specifies a functional form to be assigned to the
dose-response. See Details.}

\item{nodesplit}{A numeric vector of length 2 containing treatment codes on which to perform
an MBNMA nodesplit (see \code{\link{mbnma.nodesplit}}).}
}
\value{
A named list of numbers, vector, matrices and arrays to be sent to
JAGS. List elements are:
\itemize{
\item If \code{likelihood="normal"}:
\itemize{
\item \code{y} An array of mean responses for each arm within each study
\item \code{se} An array of standard errors for each arm within each study
}
\item If \code{likelihood="binomial"}:
\itemize{
\item \code{r} An array of the number of responses/count for each each arm within each study
\item \code{n} An array of the number of participants for each arm within each study
}
\item If \code{likelihood="poisson"}:
\itemize{
\item \code{r} An array of the number of responses/count for each each arm within each study
\item \code{E} An array of the total exposure time for each arm within each study
}
\item \code{dose} A matrix of doses for each arm within each study (if \code{level="agent"})
\item \code{narm} A numeric vector with the number of arms per study
\item \code{NS} The total number of studies in the dataset
\item \code{Nagent} The total number of agents in the dataset (if \code{level="agent"})
\item \code{agent} A matrix of agent codes within each study (if \code{level="agent"})
\item \code{NT} The total number of treatment in the dataset (if \code{level="treatment"})
\item \code{treatment} A matrix of treatment codes within each study (if \code{level="treatment"})
\item \code{Nclass} Optional. The total number of classes in the dataset
\item \code{class} Optional. A matrix of class codes within each study
\item \code{classkey} Optional. A vector of class codes that correspond to agent codes.
Same length as the number of agent codes.
\item \code{split.ind} Optional. A matrix indicating whether a specific arm contributes evidence
to a nodesplit comparison.
}
}
\description{
Converts MBNMA data frame to a list for use in JAGS model
}
\examples{
# Using the triptans headache dataset
network <- mbnma.network(triptans)
jagsdat <- getjagsdata(network$data.ab, likelihood="binomial", link="logit")


# Get JAGS data with class
netclass <- mbnma.network(osteopain)
jagsdat <- getjagsdata(netclass$data.ab, class=TRUE)


# Get JAGS data at the treatment level for split Network Meta-Analysis
network <- mbnma.network(triptans)
jagsdat <- getjagsdata(network$data.ab, level="treatment")

}
