% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOPSISLinear.R
\name{TOPSISLinear}
\alias{TOPSISLinear}
\title{Implementation of TOPSIS Method for Multi-Criteria Decision Making Problems.}
\usage{
TOPSISLinear(decision, weights, cb)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}
}
\value{
\code{TOPSISLinear} returns a data frame which contains the score of the R index and the ranking of the alternatives.
}
\description{
The \code{TOPSISLinear} function implements the Technique for Order of Preference by Similarity to Ideal Solution (TOPSIS) Method with the linear transformation of maximum as normalization prodecure.
}
\examples{

 d <- matrix(c(1,4,3,5,2,3),nrow = 3,ncol = 2)
 w <- c(0.5,0.5)
 cb <- c('max','max')
 TOPSISLinear(d,w,cb)
}
\references{
Garcia Cascales, M.S.; Lamata, M.T. On rank reversal and TOPSIS method. Mathematical and Computer Modelling, 56(5-6), 123-132, 2012.
}

