% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitions.R
\name{transitions}
\alias{transitions}
\title{Get matrix of observed transition frequencies}
\usage{
transitions(z, labels, order = 1)
}
\arguments{
\item{z}{vector of model indices (numerical or character)}

\item{labels}{fixed labels for models that should be included in transition matrix, e.g., \code{labels=1:20} or \code{c("m1","m2",...)}}

\item{order}{order of the transition table. If \code{order=1}, a matrix with transition frequencies from \code{z[t+1]} is returned. If \code{order=2}, a 3-dimensional array is returned with transition frequencies for \code{z[t]}, \code{z[t+1]}, and \code{z[t+2]}.}
}
\value{
a square matrix with transition frequencies
}
\description{
Summarizes a sequence of discrete values by the observed transition frequencies.
}
\examples{
P <- matrix(c(.9,.1,0,
              .1,.6,.3,
              .2,.3,.5), 3, byrow=TRUE)
z <- rmarkov(2000, P)
transitions(z)
transitions(z, order = 2)

}
