% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inRange.R
\name{\%withinRange\%}
\alias{\%withinRange\%}
\title{withinRange}
\usage{
lhs \%withinRange\% rhs
}
\arguments{
\item{lhs}{numeric vector.}

\item{rhs}{numeric vector of length 2 with the bounds of the range.}
}
\value{
\code{\%withinRange\%} returns a logical vector of \code{length(lhs)}, indicating which
values of \code{lhs} are and are not in range \code{rhs}. Boundaries of \code{rhs} are excluded.
}
\description{
Return which values are within a certain range

\code{\%withinRange\%} indicates which values are in a certain range, excluding
the boundaries of the range.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
a <- seq(0, 100, 5)
r <- c(40, 70)
cbind(a,
      'a \%inRange\% r' = a \%inRange\% r,
      'a \%withinRange\% r' = a \%withinRange\% r)
}
\seealso{
\code{\link{\%inRange\%}}
}
\author{
Mathijs Deen
}
