% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probeInteraction.R
\name{plot.probeInteraction}
\alias{plot.probeInteraction}
\title{plot probed interaction}
\usage{
\method{plot}{probeInteraction}(
  x,
  ...,
  col.JN = "red",
  lty.JN = "dotted",
  col.CI = rgb(red = 0.5, green = 0.5, blue = 0.5, alpha = 0.2),
  lty.CI = "longdash",
  lty.0 = "dotted"
)
}
\arguments{
\item{x}{object of class \code{probeInteraction}.}

\item{...}{other arguments (none are used).}

\item{col.JN}{color for Johnson-Neyman cut-off line(s).}

\item{lty.JN}{linetype for Johnson-Neyman cut-off line(s).}

\item{col.CI}{color of the shade for the confidence interval.}

\item{lty.CI}{linetype for confidence interval boundaries.}

\item{lty.0}{linetype for the horizontal line where the effect of the focal predictor on
the outcome equals 0.}
}
\value{
\code{plot.probeInteraction} returns a combined plot with p value on the
first y axis and effect of the antecedent variable.
}
\description{
Plot the effects of the antecedent as a function of the moderator.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
lm.1 <- lm(mpg ~ hp * wt, data = mtcars)
pI.1 <- probeInteraction(lm.1, hp, wt, JN=TRUE, n.interval.moderator = 3,
                         quantile.moderator = c(0.1,0.9), values.moderator = 2)
plot(pI.1)
lm.2 <- lm(mpg ~ qsec * drat, data = mtcars)
pI.2 <- probeInteraction(lm.2, qsec, drat, JN=TRUE, n.interval.moderator = 30,
                         quantile.moderator = c(0.1,0.9), values.moderator = 2)
plot(pI.2)
}
\author{
Mathijs Deen
}
