% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ME.fcLR_IV.R
\name{ME.fcLR_IV}
\alias{ME.fcLR_IV}
\title{Bias correction method of applying linear regression to one functional
covariate with measurement error using instrumental variable.}
\usage{
ME.fcLR_IV(
  data.Y,
  data.W,
  data.M,
  t_interval = c(0, 1),
  t_points = NULL,
  CI.bootstrap = FALSE
)
}
\arguments{
\item{data.Y}{Response variable, can be an atomic vector, a one-column matrix or data frame,
recommended form is a one-column data frame with column name.}

\item{data.W}{A dataframe or matrix, represents \eqn{W}, the measurement of \eqn{X}.
Each row represents a subject. Each column represent a measurement (time) point.}

\item{data.M}{A dataframe or matrix, represents \eqn{M}, the instrumental variable.
Each row represents a subject. Each column represent a measurement (time) point.}

\item{t_interval}{A 2-element vector, represents an interval,
means the domain of the functional covariate.
Default is \code{c(0,1)}, represent interval \eqn{[0,1]}.}

\item{t_points}{Sequence of the measurement (time) points,
default is \code{NULL}.}

\item{CI.bootstrap}{Whether to return the confidence using bootstrap method.
Default is \code{FALSE}.}
}
\value{
Returns a ME.fcLR_IV class object. It is a list that contains the following elements.
   \item{beta_tW}{Parameter estimates.}
   \item{CI}{Confidence interval, returnd only when CI.bootstrap is TRUE. }
}
\description{
See detailed model in reference
}
\examples{
data(MECfda.data.sim.0.3)
res = ME.fcLR_IV(data.Y = MECfda.data.sim.0.3$Y,
              data.W = MECfda.data.sim.0.3$W,
              data.M = MECfda.data.sim.0.3$M)
}
\references{
Tekwe, Carmen D., et al.
"Instrumental variable approach to estimating the scalar‐on‐function regression model w
ith measurement error with application to energy expenditure assessment in childhood obesity."
Statistics in medicine 38.20 (2019): 3764-3781.
}
