% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsplineSeries2fun.R
\name{bsplineSeries2fun}
\alias{bsplineSeries2fun}
\alias{bsplineSeries2fun,bspline_series,numeric-method}
\title{Compute the value of the b-splines summation series at certain points.}
\usage{
bsplineSeries2fun(object, x)

\S4method{bsplineSeries2fun}{bspline_series,numeric}(object, x)
}
\arguments{
\item{object}{an object of \code{\link{bspline_series}} class.}

\item{x}{Value of $x$.}
}
\value{
A numeric atomic vector
}
\description{
Compute the function \eqn{f(x) = \sum_{i=0}^{k}b_i B_{i,p}(x)}
}
\examples{
bsb = bspline_basis(
            Boundary.knots = c(0,24),
            intercept      = TRUE,
            df             = NULL,
            degree         = 3
)
bss = bspline_series(
          coef = c(2,1,1.5,0.5),
          bspline_basis = bsb
)
bsplineSeries2fun(bss,(1:239)/10)
}
\author{
Heyang Ji
}
