% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classDefintions.R
\docType{class}
\name{numeric_basis-class}
\alias{numeric_basis-class}
\alias{numeric_basis}
\title{Numeric representation of a function basis}
\description{
A s4 class that numerically represents a basis of linear space of function. \cr
\eqn{\{\rho_k\}_{k=1}^\infty} denotes a basis of function linear space.
Some times the basis cannot be expressed analytically.
But we can numerically store the space by the value of
a finite subset of the basis functions at some certain points in the domain,
\eqn{\rho_k(t_j), k = 1,\dots,p, j = 1,\dots,m}.
The s4 class is to represent a finite sequence of functions by their values
at a finite sequence of points within their domain,
in which all the functions have the same domain and the domain is an interval.
}
\details{
The units of a basis of a linear space should be linearly independent.
But the program doesn't check the linear dependency of the basis function
when a \code{numeric_basis} object is initialized.
}
\section{Slots}{

\describe{
\item{\code{basis_function}}{matrix of the value of the functions,
\eqn{(\zeta_{jk})_{m\times p}},
where \eqn{\zeta_{ik} = \rho_k(t_j), j = 1,\dots,m, k = 1,\dots,p}.
Each row of the matrix is corresponding to a point of \eqn{t}.
Each column of the matrix is corresponding to a basis function.}

\item{\code{t_points}}{a numeric atomic vector,
represents the points in the domains of the function
where the function values are taken.
The \eqn{j}th element is corresponding to \eqn{j}th row of
slot \code{basis_function}.}

\item{\code{t_0}}{left end of the domain interval.}

\item{\code{period}}{length of the domain interval.}
}}

\examples{
t_0 = 0
period = 1
t_points = seq(0.05,0.95,length.out = 19)
numeric_basis(
  basis_function = cbind(1/2,cos(t_points),sin(t_points)),
  t_points       = t_points,
  t_0            = t_0,
  period         = period
)
}
\author{
Heyang Ji
}
