% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.test.R
\name{feature.test}
\alias{feature.test}
\title{Inference for features identified by the Lasso}
\usage{
feature.test(x, y, B = 100, type.measure = "deviance", s = "lambda.min",
  keeplambda = FALSE, olsestimates = TRUE, penalty.factor = rep(1, nvars),
  alpha = 1, control = list(trace = FALSE, maxcores = 24), ...)
}
\arguments{
\item{x}{input matrix, of dimension nobs x nvars; each row is an observation
vector.}

\item{y}{quantitative response variable of length nobs}

\item{B}{The number of randomizations used in the computations}

\item{type.measure}{loss to use for cross-validation. See \code{cv.glmnet}
for more information}

\item{s}{Value of the penalty parameter 'lambda' at which predictions are
required. Default is the entire sequence used to create the model. See
\code{coef.glmnet} for more information}

\item{keeplambda}{If set to \code{TRUE} then the estimated lambda from cross
validation from the original dataset is kept and used for evaluation in the
subsequent randomization datasets. This reduces computation time
substantially as it is not necessary to perform cross validation for each
randomization. If set to a value then that value is used for the value of
lambda. Defaults to \code{FALSE}}

\item{olsestimates}{Logical. Should the test statistic be based on OLS
estimates from the model based on the variables selected by the lasso.
Defaults to \code{TRUE}. If set to \code{FALSE} then the coefficients from
the lasso is used as test statistics.}

\item{penalty.factor}{a vector of weights used for adaptive lasso. See
\code{glmnet} for more information.}

\item{alpha}{The elasticnet mixing parameter. See \code{glmnet} for more
information.}

\item{control}{A list of options that control the algorithm. Currently
\code{trace} is a logical and if set to \code{TRUE} then the function
produces more output. \code{maxcores} sets the maximum number of cores to
use with the \code{parallel} package}

\item{\dots}{Other arguments passed to \code{glmnet}}
}
\value{
Returns a list of 7 variables: \item{p.full }{The p-value for the
test of the full set of variables selected by the lasso (based on the OLS
estimates)} \item{ols.selected }{A vector of the indices of the non-zero
variables selected by \code{glmnet} sorted from (numerically) highest to
lowest based on their ols test statistic.} \item{p.maxols }{The p-value for
the maximum of the OLS test statistics} \item{lasso.selected }{A vector of
the indices of the non-zero variables selected by \code{glmnet} sorted from
(numerically) highest to lowest based on their absolute lasso coefficients.}
\item{p.maxlasso }{The p-value for the maximum of the lasso test statistics}
\item{lambda.orig }{The value of lambda used in the computations} \item{B
}{The number of permutations used}
}
\description{
Performs randomization tests of features identified by the Lasso
}
\examples{


# Simulate some data
x <- matrix(rnorm(30*100), nrow=30)
y <- rnorm(30, mean=1*x[,1])

# Make inference for features
\dontrun{feature.test(x, y)}


}
\references{
Brink-Jensen, K and Ekstrom, CT 2014. \emph{Inference for
feature selection using the Lasso with high-dimensional data}.
\url{http://arxiv.org/abs/1403.4296}
}
\seealso{
\code{glmnet}
}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk} and Kasper Brink-Jensen
\email{kbrink@life.ku.dk}
}
\keyword{~htests}
