% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowmeanscond.R
\name{conditional_rowMeans}
\alias{conditional_rowMeans}
\title{Form row means conditional on number of non-missing}
\usage{
conditional_rowMeans(..., minobs = 1L)
}
\arguments{
\item{...}{a series of numeric vectors, arrays, or data frames that have can be combined with cbind}

\item{minobs}{an integer stating the minimum number of non-NA observations necessary to compute the row mean. Defaults to 1.}
}
\value{
A numeric vector containing the row sums or NA if not enough non-NA observations are present
}
\description{
Form row means for multiple vectors, numeric arrays (or data frames) conditional on the number of non-missing observations.
NA is returned unless a minimum number of observations is observed.
}
\examples{
conditional_rowMeans(1:5, c(1:4, NA), c(1:3, NA, NA))
conditional_rowMeans(1:5, c(1:4, NA), c(1:3, NA, NA), minobs=0)
conditional_rowMeans(1:5, c(1:4, NA), c(1:3, NA, NA), minobs=2)

}
