% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mainfun.R
\name{MF2_multiple}
\alias{MF2_multiple}
\title{multifunctionality measures for multiple ecosystems}
\usage{
MF2_multiple(
  func_data,
  species_data = NULL,
  weight = 1,
  q = c(0, 1, 2),
  by_group = NULL
)
}
\arguments{
\item{func_data}{ecosystem function data should be input as a data.frame (ecosystems by functions for multiple ecosystems). All function values must be normalized between 0 and 1. \cr
For \code{by_group = NULL}, the \code{func_data} must contain only the ecosystem function columns. (e.g., those columns specified in the argument \code{fun_cols} if user use \code{function_normalization} to do normalization).
If \code{by_group} is not \code{NULL},in addition to ecosystem function columns, the \code{by_group} column must be included. \cr
The row names of \code{func_data} should be set the same as the names of plotID specified in \code{species_data} if \code{species_data} is not \code{NULL}.}

\item{species_data}{species abundance data should be input as a data.frame and must include three columns: "plotID", "species" and "abundance". Default is \code{NULL}.}

\item{weight}{a constant number (if all weights are equal) or a numerical vector specifying weights for ecosystem functions.
In the latter case, the length of \code{weight} must be equal to the number of functions. Default is \code{weight = 1}, which means equal weight and weight = 1 for all ecosystem functions.}

\item{q}{a numerical vector specifying the multifunctionality and diversity orders. Default is q = 0, 1 and 2.}

\item{by_group}{the column name of the stratifying variable that is used to group data for performing decomposition.
For example, if \code{by_group = "country"}, then multifunctionality decomposition is performed for any pair of plots selected within a country. \cr
The \code{by_group} setting must be the same as that set in \code{function_normalization}. Default is \code{NULL}.}
}
\value{
a data.frame with columns "plotID" (combinations of plot pairs), "Order.q" , "Type" (corr_uncorrected or corr_corrected) , "Scale" (gamma, alpha or beta) and "qMF" (multifunctionality of order q).
When \code{by_group} is not \code{NULL} (i.e., the column name of the stratifying variable is specified),
an additional column with stratification variable (e.g., "country" of the plot pairs) is also shown after the plotID column. For \code{species_data} is not \code{NULL},
the data.frame will show an additional column contain "Species.diversity" in the last column.
}
\description{
\code{MF2_multiple} computes alpha, beta and gamma multifuctionality measures of orders q = 0, 1 and 2 for given function weights in multiple ecosystems separately for two cases
(i) correlations between functions are not corrected for, and (ii) correlations between functions are corrected for.
}
\examples{

library(dplyr)

\donttest{
### Use data from five countries (data in Finland are excluded)

data("forest_function_data_normalized")
data("forest_biodiversity_data")
forest_function_data_normalized <- filter(forest_function_data_normalized, country != "FIN")
forest_biodiversity_data <- forest_biodiversity_data[-(1:48),]
MF2_multiple(func_data = forest_function_data_normalized[,6:32],
             species_data = forest_biodiversity_data,
             weight = 1,
             by_group = "country")

### Use partial data to quickly obtain output 
### (Take the first 18 plots in Germany and the last 18 plots in Italy)

data("forest_function_data_raw")
data("forest_biodiversity_data")
GER_ITA_forest_function_raw <- filter(forest_function_data_raw, 
                                      country=="GER"|country=="ITA")[c(1:18,57:74),]
GER_ITA_forest_function_normalized <- function_normalization(data = GER_ITA_forest_function_raw,
                                                             fun_cols = 6:31, 
                                                             negative = c("soil_cn_ff_10","wue"),
                                                             by_group = "country")
GER_ITA_forest_biodiversity <- forest_biodiversity_data[c(49:82,181:229),]
MF2_multiple(func_data = GER_ITA_forest_function_normalized[,6:32],
             species_data = GER_ITA_forest_biodiversity,
             weight = 1,
             by_group = "country")
}

}
