% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_sqrt_lasso.R
\name{MFKnockoffs.stat.sqrt_lasso}
\alias{MFKnockoffs.stat.sqrt_lasso}
\title{SQRT-lasso statistics for Knockoff}
\usage{
MFKnockoffs.stat.sqrt_lasso(X, X_k, y, ...)
}
\arguments{
\item{X}{original design matrix (size n-by-p)}

\item{X_k}{knockoff matrix (size n-by-p)}

\item{y}{response vector (length n) of numeric type}

\item{...}{additional arguments specific to 'slim'}
}
\value{
A vector of statistics \eqn{W} (length p)
}
\description{
Computes the signed maximum statistic
  \deqn{W_j = \max(Z_j, \tilde{Z}_j) \cdot \mathrm{sgn}(Z_j - \tilde{Z}_j),}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the maximum values of 
\eqn{\lambda} at which the jth variable and its knockoff, respectively,
enter the SQRT lasso model.
}
\details{
With default parameters, this function uses the package \code{flare}
to run the SQRT lasso. By specifying the appropriate optional parameters, 
one can use different Lasso variants including Dantzig Selector, LAD Lasso,
SQRT Lasso and Lq Lasso for estimating high dimensional sparse linear models.

For a complete list of the available additional arguments, see \link[flare]{slim}.
}
\examples{
p=50; n=50; k=10
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)

knockoffs = function(X) MFKnockoffs.create.gaussian(X, mu, Sigma)
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, statistic=MFKnockoffs.stat.sqrt_lasso)
print(result$selected)

# Advanced usage with custom arguments
foo = MFKnockoffs.stat.sqrt_lasso
k_stat = function(X, X_k, y) foo(X, X_k, y, q=0.5)
result = MFKnockoffs.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics for knockoffs: \code{\link{MFKnockoffs.stat.forward_selection}},
  \code{\link{MFKnockoffs.stat.glmnet_coef_difference}},
  \code{\link{MFKnockoffs.stat.glmnet_lambda_difference}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_coef_difference}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference_bin}},
  \code{\link{MFKnockoffs.stat.lasso_lambda_difference}},
  \code{\link{MFKnockoffs.stat.random_forest}},
  \code{\link{MFKnockoffs.stat.stability_selection}}
}
