% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Releases.R
\name{basicBatchMigration}
\alias{basicBatchMigration}
\title{Make List of Batch Migration Parameters}
\usage{
basicBatchMigration(batchProbs = 1e-05, sexProbs = c(0.01, 0.01),
  numPatches = 1)
}
\arguments{
\item{batchProbs}{Probability of a batch migration, either 1 number or vector of length equal to the number of patches}

\item{sexProbs}{Population fraction of males and females that migration. Either vector c(M,F) or matrix of 2 columns}

\item{numPatches}{Number of patches in the simulation}
}
\description{
Sets up a list containing the probability of a batch migration, the fractional amount of males/females
that migrate, and the weighted probabilities for where to migrate.
}
\examples{
# to setup for 3 patches
batchMigration = basicBatchMigration(batchProbs = 1e-5, sexProbs = c(0.1, 0.01), numPatches = 3)

}
