% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-tGD.R
\name{cubeTGD}
\alias{cubeTGD}
\title{Inheritance Cube: tGD}
\usage{
cubeTGD(
  cM1 = 0,
  cM2 = 0,
  cP1 = 0,
  cP2 = 0,
  hM1 = 0,
  hM2 = 0,
  hP1 = 0,
  hP2 = 0,
  rM1 = 0,
  rM2 = 0,
  rP1 = 0,
  rP2 = 0,
  crM = 0,
  crP = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM1}{Maternally inherited Cas9 cutting rate at locus 1}

\item{cM2}{Maternally inherited Cas9 cutting rate at locus 2}

\item{cP1}{Paternally inherited Cas9 cutting rate at locus 1}

\item{cP2}{Paternally inherited Cas9 cutting rate at locus 2}

\item{hM1}{Maternally inherited Cas9 homing efficiency at locus 1}

\item{hM2}{Maternally inherited Cas9 homing efficiency at locus 2}

\item{hP1}{Paternally inherited Cas9 homing efficiency at locus 1}

\item{hP2}{Paternally inherited Cas9 homing efficiency at locus 2}

\item{rM1}{Maternally inherited Cas9 resistance efficiency at locus 1}

\item{rM2}{Maternally inherited Cas9 resistance efficiency at locus 2}

\item{rP1}{Paternally inherited Cas9 resistance efficiency at locus 1}

\item{rP2}{Paternally inherited Cas9 resistance efficiency at locus 2}

\item{crM}{Maternal crossover rate, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{crP}{Paternal crossover rate, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
The trans-complementing Gene Drive (tGD) is a 1-locus, 2 target site drive.
The first target site corresponds to the Cas protein, the second to an effector
gene and the gRNAs. There are two sets of gRNAs, because each target site may have
different cutting/homing/resistance rates, and each sex can have different rates
for all of those things. Additionally, the parent that you receive your Cas from
dictates its efficiency.
Therefor, this construct has 5 alleles at the first locus and 4 alleles at the second.
\itemize{
\item Locus 1
\itemize{
\item W: Wild-type
\item P: Paternal Cas9
\item M: Maternal Cas9
\item R: Resistant allele 1
\item B: Resistant allele 2
}
\item Locus 2
\itemize{
\item W: Wild-type
\item G: gRNAs
\item R: Resistant 1
\item B: Resistant 2
}
}
}
\details{
This drive corresponds to the \href{https://www.nature.com/articles/s41467-019-13977-7}{transcomplementing gene drive}
developed by the Gantz and Bier lab.
}
