% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecFunctions_Final3.R
\name{summary_mono}
\alias{summary_mono}
\title{summary_mono}
\usage{
summary_mono(
  spectra.interest,
  minFrequency = 0.5,
  align.tolerance = 5e-04,
  snr = 3,
  halfWindowSize = 20,
  top.N = 50
)
}
\arguments{
\item{spectra.interest}{A list which contains peaks information for a strain of interest.}

\item{minFrequency}{Percentage value. A minimum occurrence proportion required for building a reference peaks. All peaks with their occurence proportion less than minFrequency will be moved. (Default: 0.50). See \code{\link[MALDIquant]{filterPeaks}} and \code{\link[MALDIquant]{referencePeaks}} for details.}

\item{align.tolerance}{Mass tolerance. Must be multiplied by 10^-6 for ppm. (Default: 0.0005).}

\item{snr}{Signal-to-noise ratio. (Default: 3).}

\item{halfWindowSize}{The highest peaks in the given window (+/-halfWindowSize) will be recognized as peaks. (Default: 20). See \code{\link[MALDIquant]{detectPeaks}} for details.}

\item{top.N}{The top N peaks will be chosen for the analysis. An integer value. (Default: 50).}
}
\value{
Summary information (Data frame) of spectra of interest.
}
\description{
Internal function. This function calculates summary statistics for peaks afterling aligning spectra of interest.
}
