% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHMMpackage.R
\docType{package}
\name{MHMM-package}
\alias{MHMM-package}
\alias{MHMM}
\title{Finite Mixture of Hidden Markov Models for accelerometer data}
\description{
\tabular{ll}{
  Package: \tab MHMM\cr
  Type: \tab Package\cr
  Version: \tab 1.0.0\cr
  Date: \tab 2020-03-20\cr
  License: \tab GPL-2\cr
  LazyLoad: \tab yes\cr
}
}
\examples{
data(accelero)
# To make the estimation <5
res <- mhmm(accelero, K = 2, M = 4, nbcores = 1, nbinit = 5, iterSmall = 2)
plot(res, 1)

 \donttest{
data(accelero)
# It is better to increase the number of random initializations
res <- mhmm(accelero, K = 2, M = 4, nbcores = 1)
plot(res, 1)
}
}
\references{
Du Roy de Chaumaray, M. and Marbac, M. and Navarro, F. (2019). Mixture of hidden Markov models for accelerometer data. arXiv preprint arXiv:1906.01547
}
\keyword{package}
