% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testAUC.R
\name{testAUC}
\alias{testAUC}
\title{Calculate model AUC with test data.}
\usage{
testAUC(model, transformations, data, plot = TRUE, ...)
}
\arguments{
\item{model}{The model to be projected, represented by an object of class
'glm'. This may be the object returned by \code{\link{chooseModel}}, or the
'selectedmodel' returned by \code{\link{selectEV}}.}

\item{transformations}{Transformation functions used to create the derived
variables in the model. I.e. the 'transformations' returned by
\code{\link{deriveVars}}. Equivalently, the full file pathway of the
'transformations.Rdata' file saved as a result of \code{\link{deriveVars}}.}

\item{data}{Data frame containing test occurrence data in the first column
and corresponding explanatory variables in the model in subsequent columns.
The test data should be coded as: 1/0/NA, representing presence, absence,
and uninformed. See \code{\link{readData}}.}

\item{plot}{Logical. Plot the ROC curve?}

\item{...}{Arguments to be passed to \code{plot} to control the appearance of
the ROC plot. For example: \itemize{ \item \code{lwd} for line width \item
\code{main} for plot title \item \code{cex} for plot text and symbol size }
Note that some graphical parameters may return errors or warnings if they
cannot be changed or correspond to multiple elements in the plot.}
}
\description{
For a given model, \code{testAUC} calculates the Area Under the Curve (AUC)
of the Receiver Operating Characteristic (ROC) as a threshold-independent
measure of binary classification performance. This function is intended to be
used with occurrence data that is independent from the data used to train the
model, to obtain an unbiased measure of model performance.
}
\details{
If plotted, the point along the ROC curve where the discrimination threshold
is PRO = 1, is shown for reference.
}
\examples{
\dontrun{
# From vignette:
grasslandPA <- readData(
  occurrence = system.file("extdata", "occurrence_PA.csv", package="MIAmaxent"),
  contEV = system.file("extdata", "EV_continuous", package="MIAmaxent"),
  catEV = system.file("extdata", "EV_categorical", package="MIAmaxent"),
  PA = TRUE, XY = TRUE)
head(grasslandPA)
tail(grasslandPA)
testAUC(model = grasslandmodel, transformations = grasslandDVs$transformations,
        data = grasslandPA)
}

}
