% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_converters.R
\name{move_files}
\alias{move_files}
\title{Move or copy files using logical vector}
\usage{
move_files(source_dir, target_dir, move_which, ext = ".txt", copy = FALSE)
}
\arguments{
\item{source_dir}{move from directory}

\item{target_dir}{move to directory}

\item{move_which}{logical vector to filter (or use TRUE to move all)}

\item{ext}{file extension to filter}

\item{copy}{copy files (rather than move)}
}
\value{
Logical vector, indicating success or failure for each file
}
\description{
This is simply a wrapper around file.copy/file.rename that allows for
filtering by a logical vector (move_which). This can replicate the behaviour
of a predicate function (see example), and may be easier to read.
}
\examples{
set.seed(123)
# create 10 random DNA files
tmp_dir <- tempdir()
# remove any existing .fna files
file.remove(
 list.files(tmp_dir, pattern = "*.fna", full.names = TRUE)
)
for (i in 1:10) {
writeLines(paste0(">", i, "\n", paste0(sample(c("A", "T", "C", "G"),
 100, replace = TRUE), collapse = "")), file.path(tmp_dir, paste0(i, ".fna")))
}

# move files with even numbers to a new directory
new_dir <- file.path(tempdir(), "even_files")
unlink(new_dir, recursive = TRUE)
move_files(tmp_dir,
           new_dir,
           move_which = as.integer(
              tools::file_path_sans_ext(
                  list.files(tmp_dir, pattern = "*.fna"))) \%\% 2 == 0,
           ext = "fna")
list.files(new_dir)
}
