% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QICmiipw.R
\name{QICmiipw}
\alias{QICmiipw}
\title{Model Selection criteria QIC}
\usage{
QICmiipw(model.R, model.indep, family)
}
\arguments{
\item{model.R}{fitted object obtained from GEE model \code{MeanScore,SIPW,AIPW,miSIPW,miAIPW} with correlation struture other than "independent"}

\item{model.indep}{same fitted object as in \code{model.indep} with "independent" correlation struture}

\item{family}{currently we have inlcuded
"poisson","binomial","gaussian"}
}
\value{
returns a list containing \code{QIC,QICu,Quasi likelihood}
}
\description{
It provides model selection criteria such as quasi-likelihood under the independence model criterion (QIC), an approximation to QIC under large sample i.e QICu and quasi likelihood
}
\details{
QICmiipw
}
\examples{
\dontrun{
 ##
 formula<-C6kine~ActivinRIB+ActivinRIIA+ActivinRIIAB+Adiponectin+AgRP+ALCAM
 pMat<-mice::make.predictorMatrix(srdata1[names(srdata1)\%in\%all.vars(formula)])
 m1<-MeanScore(data=srdata1,
             formula<-formula,id='ID',
             visit='Visit',family='gaussian',init.beta = NULL,
             init.alpha=NULL,init.phi=1,tol=.00001,weights = NULL,
             corstr = 'exchangeable',maxit=50,m=2,pMat=pMat)
 m11<-MeanScore(data=srdata1,
             formula<-formula,id='ID',
             visit='Visit',family='gaussian',init.beta = NULL,
             init.alpha=NULL,init.phi=1,tol=.00001,weights = NULL,
            corstr = 'independent',maxit=50,m=2,pMat=pMat)
QICmiipw(model.R=m1,model.indep=m11,family="gaussian")
##
}

}
\references{
Pan, Wei. "Akaike's information criterion in generalized estimating equations." Biometrics 57.1 (2001): 120-125.
}
