% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{class}
\name{MLZ_model-class}
\alias{MLZ_model-class}
\title{MLZ_model}
\description{
An S4 class for storing model results.
Method functions \code{summary} and \code{plot} are available for this class (see examples).
}
\section{Slots}{

\describe{
\item{\code{Stock}}{Name of stock (obtained from an object of class \code{MLZ_data}).}

\item{\code{Model}}{Name of model used for mortality estimation.}

\item{\code{time.series}}{A data frame summarizing observed time series data and predicted values from model.}

\item{\code{estimates}}{A matrix of parameter estimates and derived values and their standard errors, from
\code{\link[TMB]{sdreport}}.}

\item{\code{negLL}}{The negative log-likelihood from the model.}

\item{\code{n.changepoint}}{The number of change points in the model.}

\item{\code{n.species}}{The number of species/stocks in the model.}

\item{\code{grid.search}}{A data frame reporting the log-likelihood values from a grid search over change points.
See \code{\link{profile_ML}}, \code{\link{profile_MLCR}}, and \code{\link{profile_MLmulti}}.}

\item{\code{obj}}{A list with components from \code{\link[TMB]{MakeADFun}}.}

\item{\code{opt}}{A list with components from calling \code{\link[stats]{optim}} to \code{obj}.}

\item{\code{sdrep}}{A class \code{sdreport} list with components from calling \code{\link[TMB]{sdreport}} to \code{obj}.}

\item{\code{length.units}}{Unit of measurement for lengths, i.e. "cm" or "mm".}
}}

\examples{
\dontrun{
data(Goosefish)
goose.model <- ML(Goosefish, ncp = 2, grid.search = FALSE, figure = FALSE)
class(goose.model)

summary(goose.model)
plot(goose.model, residuals = FALSE)
}
}
