% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{ML}
\alias{ML}
\title{Mean length-based mortality estimator}
\usage{
ML(MLZ_data, ncp, start = NULL, grid.search = TRUE,
  parallel = ifelse(ncp > 2, TRUE, FALSE), min.time = 3, Z.max = 5,
  figure = TRUE)
}
\arguments{
\item{MLZ_data}{An object of class \code{\linkS4class{MLZ_data}} containing mean lengths and
life history data of stock.}

\item{ncp}{The number of change points in total mortality in the time series. \code{ncp + 1} total
mortality rates will be estimated.}

\item{start}{An optional list of starting values. See details.}

\item{grid.search}{If \code{TRUE}, a grid search will be performed using the \code{\link{profile_ML}}
function to find the best starting values for the change points (the years when mortality changes).
Ignored if \code{ncp = 0} or if \code{start} is provided.}

\item{parallel}{Whether grid search is performed with parallel processing. Ignored if \code{grid.search = FALSE}.}

\item{min.time}{The minimum number of years between each change point for the grid search, passed
to \code{\link{profile_ML}}. Not used if \code{grid.search = FALSE}.}

\item{Z.max}{The upper boundary for Z estimates.}

\item{figure}{If \code{TRUE}, a call to \code{plot} of observed and predicted mean lengths will be produced.}
}
\value{
An object of class \code{\linkS4class{MLZ_model}}.
}
\description{
Estimator of instantaneous total mortality (Z) from a time series of mean length data.
}
\details{
For a model with \code{I} change points, the starting values in
\code{start} is a list with the following entries:
Z a vector of \code{length = I+1}.
yearZ a vector of \code{length = I}.

\code{start} can be \code{NULL}, in which case, the supplied starting values depend on
the value of \code{grid.search}. If \code{grid.search = TRUE}, starting values will use the
values for \code{yearZ} which minimize the negative log-likelihood from the grid search.
Otherwise, the starting values for \code{yearZ} evenly divide the time series.
}
\examples{
\dontrun{
data(Goosefish)
res <- ML(Goosefish, ncp = 2)
res <- ML(Goosefish, ncp = 2, start = list(Z = c(0.1, 0.3, 0.5), yearZ = c(1978, 1988)))
res <- ML(Goosefish, ncp = 2, grid.search = TRUE)
}
}
\references{
Gedamke, T. and Hoenig, J.M. 2006. Estimating mortality from mean length data in
nonequilibrium situations, with application to the assessment of goosefish.
Transactions of the American Fisheries Society 135:476-487.
}
\seealso{
\code{\link{profile_ML}}
}
