% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_roc_curve}
\alias{plot_roc_curve}
\title{Plotting ROC Curve}
\usage{
plot_roc_curve(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
The \strong{plot_roc_curve()} function produces ROC (Receiver Operating Characteristic) curves, providing fundamental
visual metrics for evaluating binary and multiclass classifier performance. The ROC curve illustrates the
trade-off between true positive rate and false positive rate across different classification thresholds.
}
\examples{
# Note: For obtaining roc curve plot the user needs to
# complete till fine_tuning( ) function of the MLwrap pipeline and
# only with categorical outcome.

\dontrun{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well_bin ~ depression + emot_intel + resilience,
                             task = "classification")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Grid Search CV")

# And then, you can obtain the roc curve plot.

plot_roc_curve(wrap_object)

}

}
