% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packMOCHA.R
\name{unpackMOCHA}
\alias{unpackMOCHA}
\title{\code{unpackMOCHA}}
\usage{
unpackMOCHA(zipfile, exdir, verbose = FALSE)
}
\arguments{
\item{zipfile}{Filepath to the packed MOCHA object.}

\item{exdir}{The path to the external directory where you want to unpack the MOCHA object.}

\item{verbose}{Display additional messages. Default is FALSE.}
}
\value{
MOCHAObj the MOCHA object (tileResults or Sample-Tile Matrix)
}
\description{
\code{unpackMOCHA} will unpack a zip archive created by
  \link[MOCHA]{unpackMOCHA}, setting the stored MOCHA object's stored
  directory path to the new location. See also: \link[MOCHA]{packMOCHA}
}
\examples{
\dontrun{
# Depends on files existing on your system
MOCHA::unpackMOCHA(zipfile = "./mochaobj.zip", exdir = "./newMOCHAdir")
}
}
