% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCollection.R
\name{addCollection}
\alias{addCollection}
\title{Add New Product to MODIS Collections}
\usage{
addCollection(product, collection = NA, path_ext = "inst/external",
  overwrite = FALSE, ...)
}
\arguments{
\item{product}{Character. Name of the product that should be added to the 
'collections' dataset, see \code{\link{getCollection}}.}

\item{collection}{Numeric. Optional information about available collections. 
If not supplied, this defaults to 'NA' and the user is required to manually 
retrieve information about available collections via 
\code{getCollection(..., forceCheck = TRUE)}. Note that the latter operation 
requires the previous execution of \code{MODIS:::addProduct} and 
\code{MODIS:::addServer} to make the newly added product available to 
\code{\link{getCollection}}.}

\item{path_ext}{Character. Path to folder containing file 
'MODIS_Products.RData'. When working with RStudio projects (.Rproj), this 
usually defaults to 'inst/external'.}

\item{overwrite}{Logical. If \code{TRUE}, the initial '.RData' file located 
in 'path_ext' will be overwritten.}

\item{...}{Currently not used.}
}
\value{
A 'data.frame' which, for each product featured by \strong{MODIS}, holds 
information about available collections.
}
\description{
\code{addCollection} is a non-exported helper function to add a new product 
column to the product collections managed by \strong{MODIS} (see 
\code{MODIS:::collections}). Once added, the specified product will be 
tracked and, if required, kept up-to-date by \code{\link{getCollection}}.
}
\examples{
\dontrun{
## E.g., add collection of MODIS evapotranspiration product
MODIS:::addCollection(product = "MOD16A2", collection = 105)
}

}
\author{
Florian Detsch
}
\seealso{
\code{MODIS:::collections}.
}

