% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProduct.R
\name{getProduct}
\alias{getProduct}
\title{Check and Create Product-Related Information}
\usage{
getProduct(x = NULL, quiet = FALSE)
}
\arguments{
\item{x}{\code{character}. MODIS filename, product name, regular expression 
passed to \code{pattern} in \code{\link{grep}}, or missing.}

\item{quiet}{\code{logical}, defaults to \code{FALSE}.}
}
\value{
An invisible \code{list} with information usable by other functions or, if 
'x' is missing, a \code{data.frame} with information about all products 
available.
}
\description{
On user side, it is a funtion to find the desidered product. On package site, 
it generates central internal information to hande files.
}
\examples{
getProduct() # list available products

# or use regular expression style
getProduct("M.D11C3")
getProduct("M*D11C")

# or get information about specific product
internal_info <- getProduct("MOD11C3", quiet = TRUE) 
internal_info

}
\author{
Matteo Mattiuzzi
}
