% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{discretelogistic}
\alias{discretelogistic}
\title{discretelogistic example and figure 3.2 Discrete logistic model}
\usage{
discretelogistic(r = 0.5, K = 1000, N0 = 50, Ct = 0, Yrs = 50, p = 1)
}
\arguments{
\item{r}{intrinsic rate of population increase; default = 0.5}

\item{K}{carrying capacity; default = 1000.0}

\item{N0}{Initial population size; default=50.0 = 5 percent depletion. Note
that the term 'depletion' can be confusing. Surely 50 remaining from 1000
should be a depletion of 95 percent? But no, it is deemed to be the 
complement of 5 percent.}

\item{Ct}{annual catch default = 0.0}

\item{Yrs}{years of population growth, default=50}

\item{p}{the production curve asymmetry parameter. the default 
value of 1.0 gives the classical Schaefer model. A value of 
1e-08 approximates the Fox model where the mode is skewed to 
the left of centre.}
}
\value{
invisibly returns a matrix of year, nt, and nt1
}
\description{
discretelogistic is an implementation of equation 3.1
    in the Simple Population Models chapter 3. It enables the 
    exploration of the dynamics of the Discrete logistic model, 
    based around the classical Schaefer model. 
    
    The time-series nature of population growth is clear from 
    the fact that Nt+1 is a function of Nt. One can thus expect serial
    correlation. Setting the r parameter to <= 1.0, would 
    generate monotonically damped equilibria. r values between 
    1 < r < 2.03 would generate damped oscillatory equilibria, r 
    values from 2.03 < r < 2.43 should generate stable limit cycles 
    on a cycle of 2, 2.43 < r < 2.54 gives stable limit cycles of 
    cycle 4, then 2.54 < r < 2.57 gives cycles > 4, and ~2.575 < r 
    gives chaos (though r = 2.63 appears to generate a repeat period
    of six!). discretelogistic should be used in conjunction with 
    plot, for which an S3 method has been defined plot.dynpop. As the
    dynamics are obviously sequential (i.e. n at t+1 is dependent 
    upon n at t) the last line of the dynamics is removed to avoid 
    an empty nt1 row.
}
\examples{
  discretelogistic(0.5,1000.0,25,0.0,50) # asymptotic
  discretelogistic(2.5,1000.0,25,0.0,50) # 4-phase stable limit
  ans <- discretelogistic(r=2.55,K=1000.0,N0=100,Ct=95.0,Yrs=100)
  plot(ans)  # uses an S3 plot method for dynpop objects
}
