% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSCsimtester.R
\name{plotPops}
\alias{plotPops}
\title{Plot species tree, with population sizes on edges.}
\usage{
plotPops(stree, populations)
}
\arguments{
\item{stree}{An object of class \code{phylo} containing a rooted metric species tree.}

\item{populations}{A vector containing constant population sizes, one entry for each
edge/population in the species tree, with last entry for
the population ancestral to the root.}
}
\value{
NONE
}
\description{
Plot species tree, with population sizes on edges.
}
\examples{
stree=read.tree(text="(((a:10000,b:10000):10000,c:20000):10000,d:30000);")
plotEdgeOrder(stree)
pops=c(30000,20000,1,1,1,1,10000)
plotPops(stree,pops)

}
\seealso{
\code{\link{pairwiseDist}}, \code{\link{rootedTriple}}, \code{\link{plotEdgeOrder}}
}
