% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMtable.R
\name{PMLimit}
\alias{PMLimit}
\alias{PMObj}
\title{Create a table of Performance Limits and Performance Objectives}
\usage{
PMLimit(
  MSE,
  ...,
  Prob = NULL,
  Labels = NULL,
  FeaseMPs = NULL,
  out.file = NULL,
  output_format = "html_document",
  openFile = TRUE,
  quiet = TRUE,
  dir = NULL,
  RMDfile = NULL,
  font_size = 14,
  auto_width = FALSE,
  enableSearch = TRUE,
  PMlist = NULL,
  build = TRUE
)

PMObj(
  MSE,
  ...,
  Labels = NULL,
  out.file = NULL,
  output_format = "html_document",
  openFile = TRUE,
  quiet = TRUE,
  dir = NULL,
  RMDfile = NULL,
  font_size = 14,
  use.colors = TRUE,
  cols = NULL,
  show.legend = TRUE,
  auto_width = FALSE,
  enableSearch = TRUE,
  PMlist = NULL,
  build = TRUE,
  cex.tex = 0.75,
  inc.title = TRUE,
  title = "Legend"
)
}
\arguments{
\item{MSE}{An object of class 'MSE'}

\item{...}{PM objects to be used as performance limits. Characters (i.e names of PM objects)}

\item{Prob}{Minimum probability threshold}

\item{Labels}{Optional named list specifying new labels for MPs. For example: \code{Labels = list(AvC="Average Catch", CC1="Constant Catch")}}

\item{FeaseMPs}{Optional. Character vector of MP names that are considered feasible. e.g. the output from \code{Fease()}}

\item{out.file}{Name of the output file. If none provided, output file will be named 'PerfLimTable'}

\item{output_format}{Output file format. Currently only 'html_document' is supported}

\item{openFile}{Logical. Should the file be opened in browser?}

\item{quiet}{Logical. An option to suppress printing of the pandoc command line.}

\item{dir}{Optional. Directory for output file. Default is working directory.}

\item{RMDfile}{Optional. RMD template file}

\item{font_size}{Numeric. Font size for text in the table}

\item{auto_width}{Logical. Should table be width be automatic?}

\item{enableSearch}{Currently disabled. Logical. Should search be enabled in the html table?}

\item{PMlist}{Optional. List of PM names.}

\item{build}{Logical. Build the html table?}

\item{use.colors}{Logical. Color scale the probability text?}

\item{cols}{Optional character vector of colors for probability text}

\item{show.legend}{Logical. Show the legend??}

\item{cex.tex}{Size of legend text}

\item{inc.title}{Logical. Include title for legend?}

\item{title}{Title for the legend}
}
\value{
\code{PMLimit} invisibly returns names of MPs that pass all performance limits
}
\description{
Create a table of Performance Limits and Performance Objectives
}
\section{Functions}{
\itemize{
\item \code{PMLimit}: Create a table of Performance Limits

\item \code{PMObj}: Create a table of Performance Objectives.
}}

\examples{
\dontrun{
MSE <- runMSE()
PMLimit(MSE, "P50", "PNOF", Prob=0.9)
PMObj(MSE, "P100", "LTY")
}

}
\author{
A. Hordyk
}
