% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapmst.R
\name{mapmst}
\alias{mapmst}
\title{Map Multiscalar Typology}
\usage{
mapmst(x, var1, var2, ref, key, order, dist, mat, xid, threshold,
  superior = FALSE, colNA = "white", border = "grey80", lwd = 0.2,
  upborder = "black", uplwd = "1", add = FALSE)
}
\arguments{
\item{x}{an sf object or a SpatialPolygonsDataFrame including var1 and var2.}

\item{var1}{name of the numerator variable in x.}

\item{var2}{name of the denominator variable in x.}

\item{ref}{ratio of reference; if missing, the ratio of reference is the one of 
the whole study area (\code{sum(var1) / sum(var2)}).}

\item{key}{aggregation key field for measuring the deviation (intermediate territorial level).}

\item{order}{contiguity order.}

\item{dist}{distance threshold defining the contiguity. The cartesian 
distance between units centroids is used by default 
; use mat to apply different metrics.}

\item{mat}{a distance matrix (road distance, travel time...) between x units. 
Row and column names must fit xid identifiers. (optional)}

\item{xid}{identifier field in x (to be used for importing a personal distance matrix). Default to the first column.}

\item{threshold}{defined to build the typology (100 is considered as the average).}

\item{superior}{if TRUE, deviation values must be greater than threshold. If FALSE, 
deviation values must be lower than threshold.}

\item{colNA}{no data color}

\item{border}{color of the polygons border}

\item{lwd}{borders width}

\item{upborder}{color of the intermediate territorial level border}

\item{uplwd}{intermediate territorial level border width}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
A typology map with colours and a sf object including the ratio (var1/var2), the 3 relative 
deviations (G, T and S) and the resulting ordered typology (0 to 7). 
\itemize{Typology (which deviation is above/under the threshold):
\item{0: none}
\item{1: G }
\item{2: T}
\item{3: G and T}
\item{4: S}
\item{5: G and S}
\item{6: T and S}
\item{7: G, T and S}
}
}
\description{
Map the multiscalar typology according to the three relative 
deviations (general: G, territorial: T and spatial: S). The elementary units are classified
in eight classes according to their three relative positions and they are mapped with appropriate colors.
}
\examples{
library(sf)
library(cartography)
data("GrandParisMetropole")
# Map wealthiest territories
synthesis <- mapmst(x = com, var1 = "INC", var2 = "TH", key = "EPT",
                    order = 1,threshold = 125, superior = TRUE)
# add a layout and adapted legend
layoutLayer(title = "Multiscalar synthesis - Income per household 2013",
            sources = "GEOFLA® 2015 v2.1, Apur, impots.gouv.fr",
            north = TRUE, scale = 5, tabtitle = TRUE, frame = FALSE, theme = "red.pal",
            author = "MTA
100: Deviation average
G: Situation as compared to the global context (Grand Paris Area)
T: Situation as compared to the territorial context (EPT of belonging)
S: Situation as compared to the neigbourhood context (contiguity order 1)")
# add label territorial objects above 125\% for all the deviations
labelLayer(x = synthesis[synthesis$mst == 7, ], txt = "LIBCOM", cex = 0.6, 
           halo = TRUE, overlap = FALSE)



# Map poorest territories 
synthesis <- mapmst(x = com, var1 = "INC", var2 = "TH", key = "EPT",
                    order = 1,threshold = 75, superior = FALSE)
# add a layout
layoutLayer(title = "Multiscalar synthesis - Income per household 2013",
            sources = "GEOFLA® 2015 v2.1, Apur, impots.gouv.fr",
            north = TRUE, scale = 5, tabtitle = TRUE, frame = FALSE, theme = "red.pal",
            author = "MTA
100: Deviation average
G: Situation as compared to the global context (Grand Paris Area) 
T: Situation as compared to the territorial context (EPT of belonging) 
S: Situation as compared to the neigbourhood context (contiguity order 1)")

# add labels for territorial objects under 75 \% for all the deviations
labelLayer(x = synthesis[synthesis$mst == 7, ], txt = "LIBCOM", cex = 0.6,
           halo = TRUE)
}
